/*
 * Decompiled with CFR 0.152.
 */
package com.PartyHeartbeat;

import com.PartyHeartbeat.ClearPartyPulse;
import com.PartyHeartbeat.HeartbeatOverlay;
import com.PartyHeartbeat.PartyHeartbeatConfig;
import com.PartyHeartbeat.Pulse;
import com.PartyHeartbeat.SendStatus;
import com.google.inject.Provides;
import java.io.BufferedInputStream;
import java.util.Hashtable;
import java.util.Objects;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party Heartbeat", description="Show Party Disconnections")
public class PartyHeartbeatPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyHeartbeatPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyService party;
    @Inject
    private Hooks hooks;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HeartbeatOverlay heartbeatOverlay;
    @Inject
    private PartyHeartbeatConfig config;
    protected Clip soundClip;
    @Inject
    private Notifier notifier;
    @Inject
    Hashtable<String, Integer> partyMemberPulses = new Hashtable();

    @Provides
    PartyHeartbeatConfig provideConfig(ConfigManager configManager) {
        return (PartyHeartbeatConfig)configManager.getConfig(PartyHeartbeatConfig.class);
    }

    protected void startUp() {
        this.soundClip = this.loadSoundClip(this.config.volume());
        this.wsClient.registerMessage(Pulse.class);
        this.wsClient.registerMessage(ClearPartyPulse.class);
        this.overlayManager.add((Overlay)this.heartbeatOverlay);
    }

    protected void shutDown() {
        this.soundClip.close();
        this.partyMemberPulses.clear();
        this.wsClient.unregisterMessage(Pulse.class);
        this.wsClient.unregisterMessage(ClearPartyPulse.class);
        this.overlayManager.remove((Overlay)this.heartbeatOverlay);
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.HOPPING) || event.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.sendClearPartyPulse();
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("PartyHeartbeat") || !Objects.equals(event.getKey(), "sendPulse")) {
            return;
        }
        this.sendClearPartyPulse();
    }

    @Subscribe
    protected void onGameTick(GameTick event) {
        if (!this.party.isInParty()) {
            return;
        }
        if (this.config.alertNonRendered()) {
            for (PartyMember p : this.party.getMembers()) {
                this.notifyPlayers(p.getDisplayName());
            }
        } else {
            for (PartyMember p : this.client.getPlayers()) {
                this.notifyPlayers(p.getName());
            }
        }
        for (PartyMember p : this.party.getMembers()) {
            if (!p.isLoggedIn() || !this.partyMemberPulses.containsKey(p.getDisplayName())) continue;
            this.partyMemberPulses.put(p.getDisplayName(), this.partyMemberPulses.get(p.getDisplayName()) + 1);
        }
        if (this.config.sendPulse() == SendStatus.ON) {
            this.sendPulse();
        } else if (this.config.sendPulse() == SendStatus.HC && (this.client.getVarbitValue(1777) == 3 || this.client.getVarbitValue(1777) == 5)) {
            this.sendPulse();
        }
    }

    private void notifyPlayers(String p) {
        if (this.partyMemberPulses.containsKey(p) && this.partyMemberPulses.get(p) > this.config.maxTicks() && this.partyMemberPulses.get(p) <= this.config.maxTicks() + this.config.timeout()) {
            if (this.config.shouldNotify()) {
                this.notifier.notify("Party member " + p + " has Disconnected!");
            }
            if (this.config.shouldNotifySound()) {
                if (this.soundClip != null) {
                    FloatControl control = (FloatControl)this.soundClip.getControl(FloatControl.Type.MASTER_GAIN);
                    if (control != null) {
                        control.setValue(this.config.volume() / 2 - 45);
                    }
                    this.soundClip.setFramePosition(0);
                    this.soundClip.start();
                } else {
                    this.client.playSoundEffect(3926);
                }
            }
        }
    }

    protected Clip loadSoundClip(int volume) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(new BufferedInputStream(PartyHeartbeatPlugin.class.getResourceAsStream("/util/offerdeclined.wav")));
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip soundClip = (Clip)AudioSystem.getLine(info);
            soundClip.open(stream);
            FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
            if (control != null) {
                control.setValue(volume / 2 - 45);
            }
            return soundClip;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Subscribe
    protected void onPulse(Pulse event) {
        this.clientThread.invokeLater(() -> {
            if (!event.getPlayer().equals(this.client.getLocalPlayer().getName())) {
                this.partyMemberPulses.put(event.getPlayer(), 0);
            }
        });
    }

    private void sendPulse() {
        Pulse p;
        if (this.party.isInParty() && (p = new Pulse(this.client.getLocalPlayer().getName())).getPlayer() != null) {
            this.clientThread.invokeLater(() -> this.party.send((PartyMessage)p));
        }
    }

    @Subscribe
    protected void onClearPartyPulse(ClearPartyPulse event) {
        this.clientThread.invokeLater(() -> this.partyMemberPulses.remove(event.getPlayer()));
    }

    private void sendClearPartyPulse() {
        ClearPartyPulse p;
        if (this.party.isInParty() && (p = new ClearPartyPulse(this.client.getLocalPlayer().getName())).getPlayer() != null) {
            this.clientThread.invokeLater(() -> this.party.send((PartyMessage)p));
        }
    }
}

