/*
 * Decompiled with CFR 0.152.
 */
package com.PartyHeartbeat;

import com.PartyHeartbeat.PartyHeartbeatConfig;
import com.PartyHeartbeat.PartyHeartbeatPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class HeartbeatOverlay
extends Overlay {
    private final PartyHeartbeatPlugin plugin;
    private final PartyHeartbeatConfig config;
    @Inject
    private Client client;

    @Inject
    HeartbeatOverlay(PartyHeartbeatPlugin plugin, PartyHeartbeatConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showOverlay()) {
            this.renderDisconnects(graphics);
        }
        return null;
    }

    private void renderDisconnects(Graphics2D graphics) {
        for (Player p : this.client.getPlayers()) {
            if (!this.plugin.partyMemberPulses.containsKey(p.getName()) || this.plugin.partyMemberPulses.get(p.getName()) <= this.config.maxTicks() || this.plugin.partyMemberPulses.get(p.getName()) > this.config.maxTicks() + this.config.timeout()) continue;
            BufferedImage icon = ImageUtil.loadImageResource(PartyHeartbeatPlugin.class, (String)("/util/icon" + this.config.iconSize() + ".png"));
            this.renderSymbol(graphics, p, icon);
        }
    }

    private void renderSymbol(Graphics2D graphics, Player player, BufferedImage image) {
        Point textLocation = player.getCanvasImageLocation(image, player.getLogicalHeight() / 2);
        if (textLocation != null) {
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)textLocation, (BufferedImage)image);
        }
    }
}

