/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.utilities;

import com.marketwatcher.data.MarketWatcherItem;
import java.text.DecimalFormat;
import java.util.Map;
import net.runelite.client.util.AsyncBufferedImage;

public final class PriceUtils {
    private PriceUtils() {
    }

    public static String standardPricePadder(String price) {
        if (((String)price).length() == 1) {
            price = (String)price + "\u2800\u2800\u2800\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 2) {
            price = (String)price + "\u2800\u2800\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 3) {
            price = (String)price + "\u2800\u202f\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 4 && !((String)price).contains("M") && !((String)price).contains("K")) {
            price = (String)price + "\u2800\u202f";
            return price;
        }
        if (((String)price).length() == 4 && (((String)price).contains("M") || ((String)price).contains("K"))) {
            price = (String)price + "\u2800\u202f\u202f";
            return price;
        }
        if (!(((String)price).length() != 5 || ((String)price).contains("M") || ((String)price).contains("K") || ((String)price).contains("B"))) {
            price = (String)price + "\u2800";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("K")) {
            price = (String)price + "\u2800";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("M")) {
            price = (String)price + "\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("B")) {
            price = (String)price + "\u2800\u202f";
            return price;
        }
        if (((String)price).length() == 6) {
            price = (String)price + "\u202f";
            return price;
        }
        return price;
    }

    public static String compactPricePadder(String price) {
        if (((String)price).length() == 1) {
            price = (String)price + "\u2800\u2800\u2800";
            return price;
        }
        if (((String)price).length() == 2) {
            price = (String)price + "\u2800\u2800\u202f";
            return price;
        }
        if (((String)price).length() == 3) {
            price = (String)price + "\u2800\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 4 && !((String)price).contains("M") && !((String)price).contains("K")) {
            price = (String)price + "\u202f\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 4 && (((String)price).contains("M") || ((String)price).contains("K"))) {
            price = (String)price + "\u2800";
            return price;
        }
        if (!(((String)price).length() != 5 || ((String)price).contains("M") || ((String)price).contains("K") || ((String)price).contains("B"))) {
            price = (String)price + "\u202f\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("K")) {
            price = (String)price + "\u202f\u202f";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("M")) {
            price = (String)price + "\u202f";
            return price;
        }
        if (((String)price).length() == 5 && ((String)price).contains("B")) {
            price = (String)price + "\u202f\u202f";
            return price;
        }
        return price;
    }

    public static String[] manageItemPrices(String lowPrice, String medPrice, String highPrice, String viewType) {
        DecimalFormat df = new DecimalFormat("0.0");
        DecimalFormat df2 = new DecimalFormat("0.00");
        highPrice = PriceUtils.truncatePrices(highPrice, df, df2, viewType);
        medPrice = PriceUtils.truncatePrices(medPrice, df, df2, viewType);
        lowPrice = PriceUtils.truncatePrices(lowPrice, df, df2, viewType);
        return new String[]{lowPrice, medPrice, highPrice};
    }

    public static String truncatePrices(String price, DecimalFormat df, DecimalFormat df2, String viewType) {
        if (((String)price).equals("null")) {
            price = "N/A";
            return price;
        }
        if (((String)price).length() >= 5 && ((String)price).length() < 7) {
            price = df.format((float)Integer.parseInt((String)price) / 1000.0f) + "K";
        } else if (((String)price).length() >= 7 && ((String)price).length() < 10) {
            price = df.format((float)Integer.parseInt((String)price) / 1000000.0f) + "M";
        } else if (((String)price).length() >= 10) {
            price = df2.format((float)Integer.parseInt((String)price) / 1.0E9f) + "B";
        }
        if (viewType.equals("Standard")) {
            price = PriceUtils.standardPricePadder((String)price);
        } else if (viewType.equals("Compact")) {
            price = PriceUtils.compactPricePadder((String)price);
        }
        return price;
    }

    public static MarketWatcherItem createMarketWatchItemWithPriceMap(AsyncBufferedImage itemImage, String itemName, int itemId, int itemPrice, Map<String, String> itemPriceMap) {
        String oneWeekLow = "N/A";
        String oneWeekMed = "N/A";
        String oneWeekHigh = "N/A";
        String oneMonthLow = "N/A";
        String oneMonthMed = "N/A";
        String oneMonthHigh = "N/A";
        String threeMonthLow = "N/A";
        String threeMonthMed = "N/A";
        String threeMonthHigh = "N/A";
        if (itemPriceMap != null) {
            oneWeekLow = itemPriceMap.get("oneWeekLow") != null ? itemPriceMap.get("oneWeekLow") : "N/A";
            oneWeekMed = itemPriceMap.get("oneWeekMed") != null ? itemPriceMap.get("oneWeekMed") : "N/A";
            oneWeekHigh = itemPriceMap.get("oneWeekHigh") != null ? itemPriceMap.get("oneWeekHigh") : "N/A";
            oneMonthLow = itemPriceMap.get("oneMonthLow") != null ? itemPriceMap.get("oneMonthLow") : "N/A";
            oneMonthMed = itemPriceMap.get("oneMonthMed") != null ? itemPriceMap.get("oneMonthMed") : "N/A";
            oneMonthHigh = itemPriceMap.get("oneMonthHigh") != null ? itemPriceMap.get("oneMonthHigh") : "N/A";
            threeMonthLow = itemPriceMap.get("threeMonthsLow") != null ? itemPriceMap.get("threeMonthsLow") : "N/A";
            threeMonthMed = itemPriceMap.get("threeMonthsMed") != null ? itemPriceMap.get("threeMonthsMed") : "N/A";
            threeMonthHigh = itemPriceMap.get("threeMonthsHigh") != null ? itemPriceMap.get("threeMonthsHigh") : "N/A";
        }
        return new MarketWatcherItem(itemImage, itemName, itemId, itemPrice, oneWeekLow, oneWeekMed, oneWeekHigh, oneMonthLow, oneMonthMed, oneMonthHigh, threeMonthLow, threeMonthMed, threeMonthHigh);
    }
}

