/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.utilities;

import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.utilities.PriceUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;

public final class PanelUtils {
    private PanelUtils() {
    }

    public static JPanel createRightPanel(MarketWatcherItem item, String viewType) {
        JLabel itemImage = new JLabel();
        itemImage.setMinimumSize(new Dimension(32, 32));
        itemImage.setPreferredSize(new Dimension(32, 32));
        itemImage.setMaximumSize(new Dimension(32, 32));
        String weekLow = item.getOneWeekLow();
        String weekMed = item.getOneWeekMed();
        String weekHigh = item.getOneWeekHigh();
        String monthLow = item.getOneMonthLow();
        String monthMed = item.getOneMonthMed();
        String monthHigh = item.getOneMonthHigh();
        String threeMonthLow = item.getThreeMonthLow();
        String threeMonthMed = item.getThreeMonthMed();
        String threeMonthHigh = item.getThreeMonthHigh();
        String[] weekPrices = PriceUtils.manageItemPrices(weekLow, weekMed, weekHigh, viewType);
        String[] monthPrices = PriceUtils.manageItemPrices(monthLow, monthMed, monthHigh, viewType);
        String[] threeMonthPrices = PriceUtils.manageItemPrices(threeMonthLow, threeMonthMed, threeMonthHigh, viewType);
        if (item.getImage() != null) {
            item.getImage().addTo(itemImage);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.setBackground(new Color(0, 0, 0, 0));
        JLabel itemName = new JLabel();
        itemName.setForeground(Color.WHITE);
        String dispLabel = item.getName().substring(0, Math.min(item.getName().length(), 22));
        if (dispLabel.length() == 22) {
            dispLabel = dispLabel.concat("...");
        }
        itemName.setText(dispLabel);
        itemName.setToolTipText(item.getName());
        itemName.setMaximumSize(new Dimension(30, 15));
        rightPanel.add((Component)itemImage, PanelUtils.getGbc(gbc, 0, 0, 1, 2, 0, 0, new Insets(0, 0, 0, 3)));
        rightPanel.add((Component)itemName, PanelUtils.getGbc(gbc, 1, 0, 5, 1, 0, 0, new Insets(0, 0, 0, 0)));
        JLabel gePriceLabel = new JLabel();
        if (item.getGePrice() > 0) {
            gePriceLabel.setText(QuantityFormatter.formatNumber((long)item.getGePrice()) + " gp");
        } else {
            gePriceLabel.setText("N/A");
        }
        gePriceLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        rightPanel.add((Component)gePriceLabel, PanelUtils.getGbc(gbc, 1, 1, 5, 1, 0, 0, new Insets(0, 0, 0, 0)));
        Integer topBottomInset = viewType.equals("Standard") ? 1 : 3;
        Insets medPriceInsets = viewType.equals("Standard") ? new Insets(1, 3, 1, 3) : new Insets(3, 3, 3, 3);
        Insets lowHighPriceInsets = viewType.equals("Standard") ? new Insets(1, 0, 1, 0) : new Insets(3, 0, 3, 3);
        JLabel timeType = new JLabel();
        timeType.setForeground(Color.WHITE);
        timeType.setText("1W:");
        timeType.setToolTipText("1 Week");
        rightPanel.add((Component)timeType, PanelUtils.getGbc(gbc, 0, 2, 1, 1, 0, 0, new Insets(5, 0, topBottomInset, 0)));
        JLabel lowWeekPrice = new JLabel();
        lowWeekPrice.setForeground(Color.GREEN);
        lowWeekPrice.setText(weekPrices[0]);
        lowWeekPrice.setToolTipText(PanelUtils.formatTooltip(weekLow));
        rightPanel.add((Component)lowWeekPrice, PanelUtils.getGbc(gbc, 1, 2, 1, 1, 0, 0, new Insets(5, 0, topBottomInset, 0)));
        JLabel medWeekPrice = new JLabel();
        medWeekPrice.setForeground(Color.YELLOW);
        medWeekPrice.setText(weekPrices[1]);
        medWeekPrice.setToolTipText(PanelUtils.formatTooltip(weekMed));
        rightPanel.add((Component)medWeekPrice, PanelUtils.getGbc(gbc, 2, 2, 1, 1, 0, 0, new Insets(5, 3, topBottomInset, 3)));
        JLabel highWeekPrice = new JLabel();
        highWeekPrice.setForeground(Color.RED);
        highWeekPrice.setText(weekPrices[2]);
        highWeekPrice.setToolTipText(PanelUtils.formatTooltip(weekHigh));
        rightPanel.add((Component)highWeekPrice, PanelUtils.getGbc(gbc, 3, 2, 1, 1, 0, 0, new Insets(5, 0, topBottomInset, 0)));
        JLabel timeType2 = new JLabel();
        timeType2.setForeground(Color.WHITE);
        timeType2.setText("1M:");
        timeType2.setToolTipText("1 Month");
        rightPanel.add((Component)timeType2, PanelUtils.getGbc(gbc, 0, 3, 1, 1, 0, 0, new Insets(topBottomInset, 0, topBottomInset, 0)));
        JLabel lowMonthPrice = new JLabel();
        lowMonthPrice.setForeground(Color.GREEN);
        lowMonthPrice.setText(monthPrices[0]);
        lowMonthPrice.setToolTipText(PanelUtils.formatTooltip(monthLow));
        rightPanel.add((Component)lowMonthPrice, PanelUtils.getGbc(gbc, 1, 3, 1, 1, 0, 0, lowHighPriceInsets));
        JLabel medMonthPrice = new JLabel();
        medMonthPrice.setForeground(Color.YELLOW);
        medMonthPrice.setText(monthPrices[1]);
        medMonthPrice.setToolTipText(PanelUtils.formatTooltip(monthMed));
        rightPanel.add((Component)medMonthPrice, PanelUtils.getGbc(gbc, 2, 3, 1, 1, 0, 0, medPriceInsets));
        JLabel highMonthPrice = new JLabel();
        highMonthPrice.setForeground(Color.RED);
        highMonthPrice.setText(monthPrices[2]);
        highMonthPrice.setToolTipText(PanelUtils.formatTooltip(monthHigh));
        rightPanel.add((Component)highMonthPrice, PanelUtils.getGbc(gbc, 3, 3, 1, 1, 0, 0, lowHighPriceInsets));
        JLabel timeType3 = new JLabel();
        timeType3.setForeground(Color.WHITE);
        timeType3.setText("3M:");
        timeType3.setToolTipText("3 Months");
        rightPanel.add((Component)timeType3, PanelUtils.getGbc(gbc, 0, 4, 1, 1, 0, 0, new Insets(topBottomInset, 0, topBottomInset, 0)));
        JLabel low3MonthPrice = new JLabel();
        low3MonthPrice.setForeground(Color.GREEN);
        low3MonthPrice.setText(threeMonthPrices[0]);
        low3MonthPrice.setToolTipText(PanelUtils.formatTooltip(threeMonthLow));
        rightPanel.add((Component)low3MonthPrice, PanelUtils.getGbc(gbc, 1, 4, 1, 1, 0, 0, lowHighPriceInsets));
        JLabel med3MonthPrice = new JLabel();
        med3MonthPrice.setForeground(Color.YELLOW);
        med3MonthPrice.setText(threeMonthPrices[1]);
        med3MonthPrice.setToolTipText(PanelUtils.formatTooltip(threeMonthMed));
        rightPanel.add((Component)med3MonthPrice, PanelUtils.getGbc(gbc, 2, 4, 1, 1, 0, 0, medPriceInsets));
        JLabel high3MonthPrice = new JLabel();
        high3MonthPrice.setForeground(Color.RED);
        high3MonthPrice.setText(threeMonthPrices[2]);
        high3MonthPrice.setToolTipText(PanelUtils.formatTooltip(threeMonthHigh));
        rightPanel.add((Component)high3MonthPrice, PanelUtils.getGbc(gbc, 3, 4, 1, 1, 0, 0, lowHighPriceInsets));
        return rightPanel;
    }

    public static GridBagConstraints getGbc(GridBagConstraints gbc, int gridx, int gridy, int gridWidth, int gridHeight, int paddingX, int paddingY, Insets insets) {
        if (gridx == 1 && gridy == 0 || gridx == 0 && gridy == 0) {
            gbc.fill = 2;
        }
        gbc.gridwidth = gridWidth;
        gbc.gridheight = gridHeight;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.ipadx = paddingX;
        gbc.ipady = paddingY;
        gbc.insets = insets;
        return gbc;
    }

    public static String formatTooltip(String tooltip) {
        if (tooltip.equals("N/A") || tooltip.equals("null")) {
            return "N/A";
        }
        return QuantityFormatter.formatNumber((long)Integer.parseInt(tooltip));
    }
}

