/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.ui;

import com.marketwatcher.MarketWatcherPlugin;
import com.marketwatcher.data.MarketWatcherItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;

public class MarketWatcherTabResultPanel
extends JPanel {
    private static final Dimension IMAGE_SIZE = new Dimension(32, 32);

    MarketWatcherTabResultPanel(final MarketWatcherPlugin plugin, final MarketWatcherItem item) {
        this.setLayout(new BorderLayout(5, 0));
        this.setToolTipText(item.getName());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final Color background = this.getBackground();
        final ArrayList<JPanel> panels = new ArrayList<JPanel>();
        panels.add(this);
        MouseAdapter itemPanelMouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                plugin.addItem(item);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                for (JPanel panel : panels) {
                    panel.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
                }
                MarketWatcherTabResultPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (JPanel panel : panels) {
                    panel.setBackground(background);
                }
                MarketWatcherTabResultPanel.this.setCursor(new Cursor(0));
            }
        };
        this.addMouseListener(itemPanelMouseListener);
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        JLabel itemImage = new JLabel();
        itemImage.setPreferredSize(IMAGE_SIZE);
        if (item.getImage() != null) {
            item.getImage().addTo(itemImage);
        }
        this.add((Component)itemImage, "Before");
        JPanel rightPanel = new JPanel(new GridLayout(2, 1));
        panels.add(rightPanel);
        rightPanel.setBackground(background);
        JLabel itemName = new JLabel();
        itemName.setForeground(Color.WHITE);
        itemName.setMaximumSize(new Dimension(0, 0));
        itemName.setPreferredSize(new Dimension(0, 0));
        itemName.setText(item.getName());
        rightPanel.add(itemName);
        JLabel gePriceLabel = new JLabel();
        if (item.getGePrice() > 0) {
            gePriceLabel.setText(QuantityFormatter.formatNumber((long)item.getGePrice()) + " gp");
        } else {
            gePriceLabel.setText("N/A");
        }
        gePriceLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        rightPanel.add(gePriceLabel);
        this.add((Component)rightPanel, "Center");
    }
}

