/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.ui;

import com.marketwatcher.MarketWatcherPlugin;
import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.data.MarketWatcherTab;
import com.marketwatcher.ui.MarketWatcherPluginPanel;
import com.marketwatcher.ui.MarketWatcherSelectionPanel;
import com.marketwatcher.ui.MarketWatcherTabItemPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class MarketWatcherTabPanel
extends JPanel {
    private static final String DELETE_TITLE = "Delete Tab";
    private static final String DELETE_MESSAGE = "Are you sure you want to delete this tab? This will not delete the items.";
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon EDIT_ICON;
    private static final ImageIcon EDIT_HOVER_ICON;
    private static final ImageIcon DELETE_TAB_ICON;
    private static final ImageIcon DELETE_TAB_HOVER_ICON;
    private static final ImageIcon COLLAPSED_ICON;
    private static final ImageIcon COLLAPSED_HOVER_ICON;
    private static final ImageIcon UNCOLLAPSED_ICON;
    private static final ImageIcon UNCOLLAPSED_HOVER_ICON;
    private final boolean collapsed;

    MarketWatcherTabPanel(final MarketWatcherPlugin plugin, final MarketWatcherPluginPanel panel, final MarketWatcherTab tab) {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.collapsed = tab.isCollapsed();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        JPanel leftActions = new JPanel(new BorderLayout());
        leftActions.setOpaque(false);
        JLabel tabName = new JLabel();
        tabName.setForeground(Color.WHITE);
        tabName.setBorder(new EmptyBorder(0, 5, 0, 0));
        tabName.setPreferredSize(new Dimension(120, 0));
        tabName.setText(tab.getName());
        tabName.setToolTipText(tab.getName());
        final JLabel collapseButton = new JLabel();
        collapseButton.setOpaque(false);
        if (this.collapsed) {
            tabName.setPreferredSize(new Dimension(120, 0));
            collapseButton.setIcon(COLLAPSED_ICON);
            collapseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.switchTabCollapse(tab);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    collapseButton.setIcon(COLLAPSED_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    collapseButton.setIcon(COLLAPSED_ICON);
                }
            });
            leftActions.add((Component)tabName, "East");
            leftActions.add((Component)collapseButton, "West");
            topPanel.add((Component)leftActions, "West");
            this.add((Component)topPanel, "Center");
        } else {
            collapseButton.setIcon(UNCOLLAPSED_ICON);
            collapseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.switchTabCollapse(tab);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    collapseButton.setIcon(UNCOLLAPSED_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    collapseButton.setIcon(UNCOLLAPSED_ICON);
                }
            });
            leftActions.add((Component)tabName, "East");
            leftActions.add((Component)collapseButton, "West");
            topPanel.add((Component)leftActions, "West");
            JPanel rightActions = new JPanel(new BorderLayout());
            rightActions.setBorder(new EmptyBorder(0, 0, 0, 5));
            rightActions.setOpaque(false);
            final JLabel deleteBtn = new JLabel(DELETE_TAB_ICON);
            deleteBtn.setVerticalAlignment(0);
            deleteBtn.setBorder(new EmptyBorder(0, 0, 0, 5));
            deleteBtn.setOpaque(false);
            deleteBtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (MarketWatcherTabPanel.this.deleteConfirm()) {
                        plugin.removeTab(tab);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    deleteBtn.setIcon(DELETE_TAB_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    deleteBtn.setIcon(DELETE_TAB_ICON);
                }
            });
            rightActions.add((Component)deleteBtn, "Before");
            final JLabel edit = new JLabel(EDIT_ICON);
            edit.setVerticalAlignment(0);
            edit.setBorder(new EmptyBorder(0, 0, 0, 5));
            edit.setOpaque(false);
            edit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.editTab(tab);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    edit.setIcon(EDIT_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    edit.setIcon(EDIT_ICON);
                }
            });
            rightActions.add((Component)edit, "Center");
            final JLabel addItem = new JLabel(ADD_ICON);
            addItem.setOpaque(false);
            addItem.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    String[] itemNames = (String[])plugin.getItems().stream().map(MarketWatcherItem::getName).toArray(String[]::new);
                    Arrays.sort(itemNames, String.CASE_INSENSITIVE_ORDER);
                    MarketWatcherSelectionPanel selection = new MarketWatcherSelectionPanel((JPanel)((Object)panel), itemNames);
                    selection.setOnOk(e1 -> {
                        List<String> selectedItems = selection.getSelectedItems();
                        if (!selectedItems.isEmpty()) {
                            plugin.addItemsToTab(tab, selectedItems);
                        }
                    });
                    selection.show();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    addItem.setIcon(ADD_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    addItem.setIcon(ADD_ICON);
                }
            });
            rightActions.add((Component)addItem, "After");
            topPanel.add((Component)rightActions, "East");
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            JPanel itemsPanel = new JPanel();
            itemsPanel.setLayout(new GridBagLayout());
            itemsPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
            itemsPanel.setOpaque(false);
            int index = 0;
            for (MarketWatcherItem item : tab.getItems()) {
                MarketWatcherTabItemPanel itemPanel = new MarketWatcherTabItemPanel(plugin, tab, item);
                if (index++ > 0) {
                    itemsPanel.add((Component)this.createMarginWrapper(itemPanel), constraints);
                } else {
                    itemsPanel.add((Component)itemPanel, constraints);
                }
                ++constraints.gridy;
            }
            this.add((Component)topPanel, "North");
            this.add((Component)itemsPanel, "Center");
        }
    }

    private boolean deleteConfirm() {
        int confirm = JOptionPane.showConfirmDialog(this, DELETE_MESSAGE, DELETE_TITLE, 0);
        return confirm == 0;
    }

    private JPanel createMarginWrapper(JPanel panel) {
        JPanel marginWrapper = new JPanel(new BorderLayout());
        marginWrapper.setOpaque(false);
        marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        marginWrapper.add((Component)panel, "North");
        return marginWrapper;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(ColorScheme.DARKER_GRAY_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    static {
        BufferedImage addImage = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/addtabitemicon.png");
        ADD_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addImage, (float)0.53f));
        ADD_HOVER_ICON = new ImageIcon(addImage);
        BufferedImage editImage = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/edittabicon.png");
        EDIT_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)editImage, (float)0.53f));
        EDIT_HOVER_ICON = new ImageIcon(editImage);
        BufferedImage deleteTabImage = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/trashicon.png");
        DELETE_TAB_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteTabImage, (float)0.53f));
        DELETE_TAB_HOVER_ICON = new ImageIcon(deleteTabImage);
        BufferedImage collapsedImage = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/collapseicon.png");
        COLLAPSED_ICON = new ImageIcon(collapsedImage);
        COLLAPSED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)collapsedImage, (float)0.53f));
        BufferedImage uncollapsedImage = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/shiftdownicon.png");
        UNCOLLAPSED_ICON = new ImageIcon(uncollapsedImage);
        UNCOLLAPSED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)uncollapsedImage, (float)0.53f));
    }
}

