/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.runelite.client.ui.ColorScheme;

public class MarketWatcherSelectionPanel {
    private final JList<String> list;
    private ActionListener okEvent;
    private final JDialog dialog;
    private static final String OK = "Ok";
    private static final String CANCEL = "Cancel";
    private static final String TITLE = "Select Items";
    private static final String MESSAGE = "Select items to add to this tab";
    private static final String SUBMESSAGE = "Ctrl+Click to select multiple items";

    public MarketWatcherSelectionPanel(JPanel parent, String[] options) {
        this.list = new JList<String>(options);
        this.list.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        JLabel message = new JLabel(MESSAGE);
        message.setHorizontalAlignment(0);
        JLabel subMessage = new JLabel(SUBMESSAGE);
        subMessage.setHorizontalAlignment(0);
        topPanel.add((Component)message, "North");
        topPanel.add((Component)subMessage, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setPreferredSize(new Dimension(250, 300));
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.list.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.list);
        centerPanel.add((Component)topPanel, "North");
        centerPanel.add((Component)scrollPane, "Center");
        JOptionPane optionPane = new JOptionPane(centerPanel);
        JButton okButton = new JButton(OK);
        okButton.addActionListener(this::onOkButtonClick);
        JButton cancelButton = new JButton(CANCEL);
        cancelButton.addActionListener(this::onCancelButtonClick);
        optionPane.setOptions(new Object[]{okButton, cancelButton});
        this.dialog = optionPane.createDialog(parent, TITLE);
        this.dialog.setTitle(TITLE);
    }

    public List<String> getSelectedItems() {
        return this.list.getSelectedValuesList();
    }

    public void setOnOk(ActionListener event) {
        this.okEvent = event;
    }

    private void onOkButtonClick(ActionEvent e) {
        if (this.okEvent != null) {
            this.okEvent.actionPerformed(e);
        }
        this.dialog.setVisible(false);
    }

    private void onCancelButtonClick(ActionEvent e) {
        this.dialog.setVisible(false);
    }

    public void show() {
        this.dialog.setVisible(true);
    }
}

