/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.ui;

import com.google.common.base.Strings;
import com.marketwatcher.MarketWatcherPlugin;
import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.data.MarketWatcherTab;
import com.marketwatcher.ui.MarketWatcherItemPanel;
import com.marketwatcher.ui.MarketWatcherTabPanel;
import com.marketwatcher.ui.MarketWatcherTabResultPanel;
import com.marketwatcher.utilities.PriceUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemPrice;

public class MarketWatcherPluginPanel
extends PluginPanel {
    private final MarketWatcherPlugin plugin;
    private final ClientThread clientThread;
    private final RuneLiteConfig runeLiteConfig;
    private final ItemManager itemManager;
    private static final int MAX_SEARCH_ITEMS = 100;
    private static final String MARKET_WATCH_PANEL = "MARKET_WATCH_PANEL";
    private static final String SEARCH_PANEL = "SEARCH_PANEL";
    private static final String RESULTS_PANEL = "RESULTS_PANEL";
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private static final String PANEL_TITLE = "Market Watcher";
    private static final String GE_SEARCH_TITLE = "Grand Exchange Search";
    private static final String CONTAINS_ITEM_TITLE = "Info";
    private static final String SEARCH_PROMPT = "Search for an item to select";
    private static final String INFO_TOOLTIP = "Information";
    private static final String ADD_ITEM_TOOLTIP = "Add an item from the Grand Exchange";
    private static final String ADD_TAB_ITEM_TOOLTIP = "Add an item tab";
    private static final String CONTAINS_ITEM_MESSAGE = "This item is already being tracked.";
    private static final String SEARCH_ERROR = "No results found.";
    private static final String SEARCH_ERROR_MESSAGE = "No items were found with that name, please try again.";
    private static final String CANCEL = "Cancel";
    private static final ImageIcon INFO_ICON;
    private static final ImageIcon INFO_HOVER_ICON;
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon ADD_TAB_ICON;
    private static final ImageIcon ADD_TAB_HOVER_ICON;
    private static final ImageIcon CANCEL_ICON;
    private static final ImageIcon CANCEL_HOVER_ICON;
    private final JLabel cancelItem = new JLabel(CANCEL_ICON);
    private final CardLayout centerCard = new CardLayout();
    private final CardLayout searchCard = new CardLayout();
    private final JPanel centerPanel = new JPanel(this.centerCard);
    private final JPanel marketWatcherPanel = new JPanel(new BorderLayout());
    private final JPanel titlePanel = new JPanel(new BorderLayout());
    private final JPanel searchPanel = new JPanel(new BorderLayout());
    private final JPanel searchCenterPanel = new JPanel(this.searchCard);
    private final JPanel searchResultsPanel = new JPanel();
    private final JPanel marketWatcherItemsPanel = new JPanel();
    private final IconTextField searchBar = new IconTextField();
    private final PluginErrorPanel searchErrorPanel = new PluginErrorPanel();
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final JLabel title = new JLabel();
    private final JPanel actionPanel = new JPanel(new BorderLayout());
    private final JLabel information = new JLabel(INFO_ICON);
    private final JLabel addTabItem = new JLabel(ADD_TAB_ICON);
    private final JLabel addItem = new JLabel(ADD_ICON);
    private final List<MarketWatcherItem> searchItems = new ArrayList<MarketWatcherItem>();

    @Inject
    MarketWatcherPluginPanel(final MarketWatcherPlugin plugin, ClientThread clientThread, RuneLiteConfig runeLiteConfig, ItemManager itemManager) throws IOException {
        super(false);
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.runeLiteConfig = runeLiteConfig;
        this.itemManager = itemManager;
        this.setLayout(new BorderLayout());
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.title.setText(PANEL_TITLE);
        this.title.setForeground(Color.WHITE);
        this.title.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.title.setPreferredSize(new Dimension(100, 10));
        JPanel actions = new JPanel(new FlowLayout(2, 3, 3));
        this.information.setToolTipText(INFO_TOOLTIP);
        this.information.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.information.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                plugin.showHelp();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MarketWatcherPluginPanel.this.information.setIcon(INFO_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MarketWatcherPluginPanel.this.information.setIcon(INFO_ICON);
            }
        });
        this.actionPanel.add((Component)this.information, "Before");
        this.addTabItem.setToolTipText(ADD_TAB_ITEM_TOOLTIP);
        this.addTabItem.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.addTabItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                plugin.addTab();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MarketWatcherPluginPanel.this.addTabItem.setIcon(ADD_TAB_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MarketWatcherPluginPanel.this.addTabItem.setIcon(ADD_TAB_ICON);
            }
        });
        this.actionPanel.add((Component)this.addTabItem, "Center");
        this.addItem.setToolTipText(ADD_ITEM_TOOLTIP);
        this.addItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MarketWatcherPluginPanel.this.switchToSearch();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MarketWatcherPluginPanel.this.addItem.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MarketWatcherPluginPanel.this.addItem.setIcon(ADD_ICON);
            }
        });
        this.actionPanel.add((Component)this.addItem, "After");
        actions.add(this.actionPanel);
        this.cancelItem.setToolTipText(CANCEL);
        this.cancelItem.setVisible(false);
        this.cancelItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MarketWatcherPluginPanel.this.switchToMarketWatch();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MarketWatcherPluginPanel.this.cancelItem.setIcon(CANCEL_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MarketWatcherPluginPanel.this.cancelItem.setIcon(CANCEL_ICON);
            }
        });
        actions.add(this.cancelItem);
        this.titlePanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.titlePanel.add((Component)this.title, "Before");
        this.titlePanel.add((Component)actions, "After");
        this.marketWatcherItemsPanel.setLayout(new GridBagLayout());
        JPanel pWrapper = new JPanel(new BorderLayout());
        pWrapper.add((Component)this.marketWatcherItemsPanel, "North");
        JScrollPane marketWrapper = new JScrollPane(pWrapper);
        marketWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        marketWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        marketWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        marketWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(5, 5, 0, 0));
        this.marketWatcherPanel.add((Component)marketWrapper, "Center");
        this.searchResultsPanel.setLayout(new GridBagLayout());
        JPanel searchResultsWrapper = new JPanel(new BorderLayout());
        searchResultsWrapper.add((Component)this.searchResultsPanel, "North");
        JScrollPane resultsWrapper = new JScrollPane(searchResultsWrapper);
        resultsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resultsWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        resultsWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        resultsWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(5, 5, 0, 0));
        this.constraints.fill = 2;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.searchErrorPanel.setContent(GE_SEARCH_TITLE, SEARCH_PROMPT);
        JPanel errorWrapper = new JPanel(new BorderLayout());
        errorWrapper.add((Component)this.searchErrorPanel, "North");
        this.searchCenterPanel.add((Component)resultsWrapper, RESULTS_PANEL);
        this.searchCenterPanel.add((Component)errorWrapper, ERROR_PANEL);
        this.searchCard.show(this.searchCenterPanel, ERROR_PANEL);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(210, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addClearListener(this::searchForItems);
        this.searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MarketWatcherPluginPanel.this.searchForItems();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.searchPanel.add((Component)this.searchBar, "North");
        this.searchPanel.add((Component)this.searchCenterPanel, "Center");
        this.centerPanel.add((Component)this.marketWatcherPanel, MARKET_WATCH_PANEL);
        this.centerPanel.add((Component)this.searchPanel, SEARCH_PANEL);
        this.centerCard.show(this.centerPanel, MARKET_WATCH_PANEL);
        container.add((Component)this.titlePanel, "North");
        container.add((Component)this.centerPanel, "Center");
        this.add(container, "Center");
    }

    public void switchToMarketWatch() {
        this.cancelItem.setVisible(false);
        this.actionPanel.setVisible(true);
        this.centerCard.show(this.centerPanel, MARKET_WATCH_PANEL);
    }

    private void switchToSearch() {
        this.actionPanel.setVisible(false);
        this.cancelItem.setVisible(true);
        this.centerCard.show(this.centerPanel, SEARCH_PANEL);
    }

    private void searchForItems() {
        String lookup = this.searchBar.getText();
        this.searchResultsPanel.removeAll();
        if (Strings.isNullOrEmpty((String)lookup)) {
            this.searchResultsPanel.removeAll();
            SwingUtilities.invokeLater(this.searchResultsPanel::updateUI);
            return;
        }
        List results = this.itemManager.search(this.searchBar.getText());
        if (results.isEmpty()) {
            this.searchErrorPanel.setContent(SEARCH_ERROR, SEARCH_ERROR_MESSAGE);
            this.searchCard.show(this.searchCenterPanel, ERROR_PANEL);
            return;
        }
        this.clientThread.invokeLater(() -> this.processResults(results));
    }

    private void processResults(List<ItemPrice> results) {
        this.searchItems.clear();
        this.searchCard.show(this.searchCenterPanel, RESULTS_PANEL);
        int count = 0;
        boolean useActivelyTradedPrice = this.runeLiteConfig.useWikiItemPrices();
        for (ItemPrice item : results) {
            if (count++ > 100) break;
            int itemId = item.getId();
            AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
            int itemPrice = useActivelyTradedPrice ? this.itemManager.getWikiPrice(item) : item.getPrice();
            Map<String, String> itemPriceMap = this.plugin.getItemPriceMap().get(itemId);
            MarketWatcherItem resultItem = PriceUtils.createMarketWatchItemWithPriceMap(itemImage, item.getName(), itemId, itemPrice, itemPriceMap);
            this.searchItems.add(resultItem);
        }
        SwingUtilities.invokeLater(() -> {
            int index = 0;
            for (MarketWatcherItem item : this.searchItems) {
                MarketWatcherTabResultPanel panel = new MarketWatcherTabResultPanel(this.plugin, item);
                if (index++ > 0) {
                    this.searchResultsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
                } else {
                    this.searchResultsPanel.add((Component)panel, this.constraints);
                }
                ++this.constraints.gridy;
            }
            this.validate();
        });
    }

    public void updateMarketWatchPanel() {
        JPanel panel;
        this.marketWatcherItemsPanel.removeAll();
        ++this.constraints.gridy;
        int index = 0;
        for (MarketWatcherTab tab : this.plugin.getTabs()) {
            panel = new MarketWatcherTabPanel(this.plugin, this, tab);
            if (index++ > 0) {
                this.marketWatcherItemsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
            } else {
                this.marketWatcherItemsPanel.add((Component)panel, this.constraints);
            }
            ++this.constraints.gridy;
        }
        for (MarketWatcherItem item : this.plugin.getItems()) {
            panel = new MarketWatcherItemPanel(this.plugin, item);
            if (index++ > 0) {
                this.marketWatcherItemsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
            } else {
                this.marketWatcherItemsPanel.add((Component)panel, this.constraints);
            }
            ++this.constraints.gridy;
        }
        this.validate();
    }

    public void containsItemWarning() {
        JOptionPane.showConfirmDialog((Component)((Object)this), CONTAINS_ITEM_MESSAGE, CONTAINS_ITEM_TITLE, -1);
    }

    private JPanel createMarginWrapper(JPanel panel) {
        JPanel marginWrapper = new JPanel(new BorderLayout());
        marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        marginWrapper.add((Component)panel, "North");
        return marginWrapper;
    }

    static {
        BufferedImage infoImage = ImageUtil.loadImageResource(MarketWatcherPluginPanel.class, (String)"/infoicon.png");
        INFO_ICON = new ImageIcon(infoImage);
        INFO_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)infoImage, (float)0.53f));
        BufferedImage addImage = ImageUtil.loadImageResource(MarketWatcherPluginPanel.class, (String)"/addicon.png");
        ADD_ICON = new ImageIcon(addImage);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addImage, (float)0.53f));
        BufferedImage addTabImage = ImageUtil.loadImageResource(MarketWatcherPluginPanel.class, (String)"/addtabicon.png");
        ADD_TAB_ICON = new ImageIcon(addTabImage);
        ADD_TAB_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addTabImage, (float)0.53f));
        BufferedImage cancelImage = ImageUtil.loadImageResource(MarketWatcherPluginPanel.class, (String)"/cancelicon.png");
        CANCEL_ICON = new ImageIcon(cancelImage);
        CANCEL_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)cancelImage, (float)0.53f));
    }
}

