/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.ui;

import com.marketwatcher.MarketWatcherPlugin;
import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.utilities.PanelUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class MarketWatcherItemPanel
extends JPanel {
    private static final String DELETE_TITLE = "Warning";
    private static final String DELETE_MESSAGE = "Are you sure you want to delete this item?";
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon SHIFT_UP_ICON;
    private static final ImageIcon SHIFT_UP_HOVER_ICON;
    private static final ImageIcon SHIFT_DOWN_ICON;
    private static final ImageIcon SHIFT_DOWN_HOVER_ICON;

    MarketWatcherItemPanel(final MarketWatcherPlugin plugin, final MarketWatcherItem item) {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        final int itemIndex = plugin.getItems().indexOf(item);
        final int itemsSize = plugin.getItems().size();
        JPanel rightPanel = PanelUtils.createRightPanel(item, "Standard");
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.setBackground(new Color(0, 0, 0, 0));
        actionPanel.setOpaque(false);
        final JLabel deleteItem = new JLabel(DELETE_ICON);
        deleteItem.setBorder(new EmptyBorder(0, 0, 0, 3));
        deleteItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MarketWatcherItemPanel.this.deleteConfirm()) {
                    plugin.removeItem(item);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteItem.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteItem.setIcon(DELETE_ICON);
            }
        });
        actionPanel.add((Component)deleteItem, "North");
        JPanel shiftItemPanel = new JPanel(new BorderLayout());
        shiftItemPanel.setOpaque(false);
        final JLabel shiftUp = new JLabel(SHIFT_UP_ICON);
        shiftUp.setBorder(new EmptyBorder(0, 0, 15, 5));
        if (itemIndex == 0) {
            shiftUp.setIcon(SHIFT_UP_HOVER_ICON);
        }
        shiftUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (itemIndex != 0) {
                    plugin.shiftItem(itemIndex, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                shiftUp.setIcon(SHIFT_UP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (itemIndex != 0) {
                    shiftUp.setIcon(SHIFT_UP_ICON);
                }
            }
        });
        shiftItemPanel.add((Component)shiftUp, "North");
        final JLabel shiftDown = new JLabel(SHIFT_DOWN_ICON);
        shiftDown.setBorder(new EmptyBorder(15, 0, 20, 5));
        if (itemIndex == itemsSize - 1) {
            shiftDown.setIcon(SHIFT_DOWN_HOVER_ICON);
        }
        shiftDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (itemIndex != itemsSize - 1) {
                    plugin.shiftItem(itemIndex, false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                shiftDown.setIcon(SHIFT_DOWN_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (itemIndex != itemsSize - 1) {
                    shiftDown.setIcon(SHIFT_DOWN_ICON);
                }
            }
        });
        shiftItemPanel.add((Component)shiftDown, "East");
        actionPanel.add((Component)shiftItemPanel, "South");
        this.add((Component)rightPanel, "West");
        this.add((Component)actionPanel, "East");
    }

    private boolean deleteConfirm() {
        int confirm = JOptionPane.showConfirmDialog(this, DELETE_MESSAGE, DELETE_TITLE, 0);
        return confirm == 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(ColorScheme.DARKER_GRAY_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    static {
        BufferedImage deleteImage = ImageUtil.loadImageResource(MarketWatcherItemPanel.class, (String)"/deleteicon.png");
        DELETE_ICON = new ImageIcon(deleteImage);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImage, (float)0.53f));
        BufferedImage shiftUpImage = ImageUtil.loadImageResource(MarketWatcherItemPanel.class, (String)"/shiftupicon.png");
        SHIFT_UP_ICON = new ImageIcon(shiftUpImage);
        SHIFT_UP_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)shiftUpImage, (float)0.53f));
        BufferedImage shiftDownImage = ImageUtil.loadImageResource(MarketWatcherItemPanel.class, (String)"/shiftdownicon.png");
        SHIFT_DOWN_ICON = new ImageIcon(shiftDownImage);
        SHIFT_DOWN_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)shiftDownImage, (float)0.53f));
    }
}

