/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.marketwatcher.MarketWatcherPlugin;
import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.data.MarketWatcherTab;
import com.marketwatcher.data.MarketWatcherTabData;
import com.marketwatcher.utilities.PriceUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketWatcherTabDataManager {
    private static final Logger log = LoggerFactory.getLogger(MarketWatcherTabDataManager.class);
    private static final String CONFIG_KEY_ITEMIDS = "itemIds";
    private static final String CONFIG_KEY_TABS = "tabs";
    private static final String LOAD_ITEM_ERROR = "Exception occurred while loading items";
    private static final String LOAD_TAB_ERROR = "Exception occurred while loading tabs";
    private static final String EMPTY_ARRAY = "[]";
    private final MarketWatcherPlugin plugin;
    private final Client client;
    private final ConfigManager configManager;
    private final ItemManager itemManager;
    private final Gson gson;
    private List<Integer> itemIds = new ArrayList<Integer>();
    private final Type itemsType = new TypeToken<ArrayList<Integer>>(){}.getType();
    private List<MarketWatcherTabData> tabs = new ArrayList<MarketWatcherTabData>();
    private final Type tabsType = new TypeToken<ArrayList<MarketWatcherTabData>>(){}.getType();

    @Inject
    public MarketWatcherTabDataManager(MarketWatcherPlugin plugin, Client client, ConfigManager configManager, ItemManager itemManager, Gson gson) {
        this.plugin = plugin;
        this.client = client;
        this.configManager = configManager;
        this.itemManager = itemManager;
        this.gson = gson;
    }

    public boolean loadData() {
        if (this.client.getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            return false;
        }
        this.itemIds.clear();
        String itemsJson = this.configManager.getConfiguration("marketwatch", CONFIG_KEY_ITEMIDS);
        if (itemsJson == null || itemsJson.equals(EMPTY_ARRAY)) {
            this.plugin.setItems(new ArrayList<MarketWatcherItem>());
        } else {
            try {
                this.itemIds = (List)this.gson.fromJson(itemsJson, this.itemsType);
                this.convertItems();
            }
            catch (Exception e) {
                log.error(LOAD_ITEM_ERROR, (Throwable)e);
                this.plugin.setItems(new ArrayList<MarketWatcherItem>());
            }
        }
        this.tabs.clear();
        String tabsJson = this.configManager.getConfiguration("marketwatch", CONFIG_KEY_TABS);
        if (tabsJson == null || tabsJson.equals(EMPTY_ARRAY)) {
            this.plugin.setTabs(new ArrayList<MarketWatcherTab>());
        } else {
            try {
                this.tabs = (List)this.gson.fromJson(tabsJson, this.tabsType);
                this.convertTabs();
            }
            catch (Exception e) {
                log.error(LOAD_TAB_ERROR, (Throwable)e);
                this.plugin.setTabs(new ArrayList<MarketWatcherTab>());
            }
        }
        this.plugin.updateItemPrices();
        return true;
    }

    public void saveData() {
        this.itemIds.clear();
        for (MarketWatcherItem marketWatcherItem : this.plugin.getItems()) {
            this.itemIds.add(marketWatcherItem.getItemId());
        }
        String itemsJson = this.gson.toJson(this.itemIds);
        this.configManager.setConfiguration("marketwatch", CONFIG_KEY_ITEMIDS, itemsJson);
        this.tabs.clear();
        for (MarketWatcherTab tab : this.plugin.getTabs()) {
            ArrayList<Integer> tabItems = new ArrayList<Integer>();
            for (MarketWatcherItem item : tab.getItems()) {
                tabItems.add(item.getItemId());
            }
            this.tabs.add(new MarketWatcherTabData(tab.getName(), tab.isCollapsed(), tabItems));
        }
        String string = this.gson.toJson(this.tabs);
        this.configManager.setConfiguration("marketwatch", CONFIG_KEY_TABS, string);
    }

    private void convertItems() {
        ArrayList<MarketWatcherItem> watchItems = new ArrayList<MarketWatcherItem>();
        for (Integer itemId : this.itemIds) {
            watchItems.add(this.convertIdToItem(itemId));
        }
        this.plugin.setItems(watchItems);
    }

    private void convertTabs() {
        ArrayList<MarketWatcherTab> watchTabs = new ArrayList<MarketWatcherTab>();
        for (MarketWatcherTabData tab : this.tabs) {
            ArrayList<MarketWatcherItem> tabItems = new ArrayList<MarketWatcherItem>();
            for (Integer itemId : tab.getItems()) {
                tabItems.add(this.convertIdToItem(itemId));
            }
            watchTabs.add(new MarketWatcherTab(tab.getName(), tab.isCollapsed(), tabItems));
        }
        this.plugin.setTabs(watchTabs);
    }

    private MarketWatcherItem convertIdToItem(int itemId) {
        AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
        String itemName = this.itemManager.getItemComposition(itemId).getName();
        Map<String, String> itemPriceMap = this.plugin.getItemPriceMap().get(itemId);
        return PriceUtils.createMarketWatchItemWithPriceMap(itemImage, itemName, itemId, 0, itemPriceMap);
    }
}

