/*
 * Decompiled with CFR 0.152.
 */
package com.marketwatcher;

import com.google.gson.Gson;
import com.marketwatcher.data.MarketWatcherItem;
import com.marketwatcher.data.MarketWatcherTab;
import com.marketwatcher.data.MarketWatcherTabDataManager;
import com.marketwatcher.ui.MarketWatcherPluginPanel;
import com.marketwatcher.utilities.WikiItemDetails;
import com.marketwatcher.utilities.WikiRequestResult;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Market Watcher")
public class MarketWatcherPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MarketWatcherPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private MarketWatcherTabDataManager dataManager;
    @Inject
    private ClientToolbar clientToolbar;
    private List<MarketWatcherItem> items = new ArrayList<MarketWatcherItem>();
    private List<MarketWatcherTab> tabs = new ArrayList<MarketWatcherTab>();
    Map<Integer, Map<String, String>> itemPriceMap = new HashMap<Integer, Map<String, String>>();
    private OkHttpClient okHttpClient;
    private MarketWatcherPluginPanel panel;
    private NavigationButton navButton;
    private static final String ADD_EDIT_TAB_MESSAGE = "Enter the name of this tab (30 chars max).";
    private static final String ADD_NEW_TAB_TITLE = "Add New Tab";
    private static final String EDIT_TAB_TITLE = "Edit Tab";

    protected void startUp() throws Exception {
        this.retrieveItemPriceHistories("oneWeek");
        this.retrieveItemPriceHistories("oneMonth");
        this.retrieveItemPriceHistories("threeMonths");
        this.panel = (MarketWatcherPluginPanel)((Object)this.injector.getInstance(MarketWatcherPluginPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(MarketWatcherPlugin.class, (String)"/panelicon.png");
        this.navButton = NavigationButton.builder().tooltip("Market Watcher").icon(icon).priority(11).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.dataManager = new MarketWatcherTabDataManager(this, this.client, this.configManager, this.itemManager, this.gson);
        this.clientThread.invokeLater(() -> this.dataManager.loadData());
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void addItem(MarketWatcherItem item) {
        this.clientThread.invokeLater(() -> {
            if (!this.containsItem(item)) {
                this.items.add(item);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> {
                    this.panel.switchToMarketWatch();
                    this.panel.updateMarketWatchPanel();
                });
            } else {
                SwingUtilities.invokeLater(() -> this.panel.containsItemWarning());
            }
        });
    }

    public void removeItem(MarketWatcherItem item) {
        this.clientThread.invokeLater(() -> {
            this.items.remove(item);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void addItemsToTab(MarketWatcherTab tab, List<String> itemNames) {
        this.clientThread.invokeLater(() -> {
            for (String itemName : itemNames) {
                MarketWatcherItem item = this.items.stream().filter(o -> o.getName().equals(itemName)).findFirst().orElse(null);
                tab.getItems().add(item);
                this.items.remove(item);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void removeItemFromTab(MarketWatcherTab tab, MarketWatcherItem item) {
        this.clientThread.invokeLater(() -> {
            tab.getItems().remove(item);
            this.items.add(item);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void switchTabCollapse(MarketWatcherTab tab) {
        this.clientThread.invokeLater(() -> {
            tab.setCollapsed(!tab.isCollapsed());
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void addTab() {
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), ADD_EDIT_TAB_MESSAGE, ADD_NEW_TAB_TITLE, -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        String tabName = name;
        this.clientThread.invokeLater(() -> {
            MarketWatcherTab tab = new MarketWatcherTab(tabName, new ArrayList<MarketWatcherItem>());
            if (!this.tabs.contains(tab)) {
                this.tabs.add(tab);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
            }
        });
    }

    public void showHelp() {
        JOptionPane.showMessageDialog((Component)((Object)this.panel), "Each item displays price history for the past week, month, and 3 months. \nFor each time period, the price lows, averages, and highs are color coded in rows. \nGreen numbers are lows. Yellow numbers are averages. Red numbers are highs.", "Information", 1);
    }

    public void shiftItem(int itemIndex, boolean shiftUp) {
        this.clientThread.invokeLater(() -> {
            MarketWatcherItem shiftedItem = this.items.get(itemIndex);
            if (shiftUp) {
                this.items.set(itemIndex, this.items.get(itemIndex - 1));
                this.items.set(itemIndex - 1, shiftedItem);
            } else {
                this.items.set(itemIndex, this.items.get(itemIndex + 1));
                this.items.set(itemIndex + 1, shiftedItem);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void shiftItemInTab(MarketWatcherTab tab, int itemIndex, boolean shiftUp) {
        this.clientThread.invokeLater(() -> {
            List<MarketWatcherItem> tabItems = tab.getItems();
            MarketWatcherItem shiftedItem = tab.getItems().get(itemIndex);
            if (shiftUp) {
                tabItems.set(itemIndex, tabItems.get(itemIndex - 1));
                tabItems.set(itemIndex - 1, shiftedItem);
            } else {
                tabItems.set(itemIndex, tabItems.get(itemIndex + 1));
                tabItems.set(itemIndex + 1, shiftedItem);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void removeTab(MarketWatcherTab tab) {
        this.clientThread.invokeLater(() -> {
            this.items.addAll(tab.getItems());
            this.tabs.remove(tab);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
        });
    }

    public void updateItemPrices() {
        for (MarketWatcherTab tab : this.tabs) {
            for (MarketWatcherItem item : tab.getItems()) {
                item.setGePrice(this.itemManager.getItemPrice(item.getItemId()));
            }
        }
        for (MarketWatcherItem item : this.items) {
            item.setGePrice(this.itemManager.getItemPrice(item.getItemId()));
        }
        SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
    }

    public void editTab(MarketWatcherTab tab) {
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), ADD_EDIT_TAB_MESSAGE, EDIT_TAB_TITLE, -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        String tabName = name;
        this.clientThread.invokeLater(() -> {
            MarketWatcherTab nameCheck = this.tabs.stream().filter(o -> o.getName().equals(tabName)).findFirst().orElse(null);
            if (nameCheck == null) {
                tab.setName(tabName);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> this.panel.updateMarketWatchPanel());
            }
        });
    }

    private boolean containsItem(MarketWatcherItem newItem) {
        for (MarketWatcherTab tab : this.tabs) {
            if (!tab.getItems().contains(newItem)) continue;
            return true;
        }
        return this.items.contains(newItem);
    }

    private void retrieveItemPriceHistories(String timePeriod) throws Exception {
        long timeBuffer;
        String resp = "";
        long unixTimestamp = Instant.now().getEpochSecond();
        String unixTimeString = "";
        if (timePeriod.equals("oneWeek")) {
            long oneWeekAgo = unixTimestamp - 604800L;
            timeBuffer = oneWeekAgo % 21600L;
            unixTimeString = String.valueOf(oneWeekAgo - timeBuffer);
        } else if (timePeriod.equals("oneMonth")) {
            long oneMonthAgo = unixTimestamp - 2592000L;
            timeBuffer = oneMonthAgo % 21600L;
            unixTimeString = String.valueOf(oneMonthAgo - timeBuffer);
        } else if (timePeriod.equals("threeMonths")) {
            long threeMonthsAgo = unixTimestamp - 7776000L;
            timeBuffer = threeMonthsAgo % 21600L;
            unixTimeString = String.valueOf(threeMonthsAgo - timeBuffer);
        }
        Request request = new Request.Builder().url("https://prices.runescape.wiki/api/v1/osrs/6h?timestamp=" + unixTimeString).header("User-Agent", "Market Watcher Plugin").build();
        this.okHttpClient = (OkHttpClient)this.injector.getInstance(OkHttpClient.class);
        try (Response response = this.okHttpClient.newCall(request).execute();){
            resp = response.body().string();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        WikiRequestResult wikiRequestResult = (WikiRequestResult)this.gson.fromJson(resp, WikiRequestResult.class);
        for (Map.Entry<Integer, WikiItemDetails> entry : wikiRequestResult.getData().entrySet()) {
            int currentID;
            Map<String, String> timeFrameValuesMapping;
            String lowPrice = Integer.toString(entry.getValue().getAvgLowPrice());
            String medPrice = "N/A";
            String highPrice = Integer.toString(entry.getValue().getAvgHighPrice());
            if (highPrice.equals("0")) {
                highPrice = "N/A";
            }
            if (lowPrice.equals("0")) {
                lowPrice = "N/A";
            }
            if (!highPrice.equals("N/A") && !lowPrice.equals("N/A")) {
                BigInteger highPriceInteger = BigInteger.valueOf(Integer.parseInt(highPrice));
                BigInteger lowPriceInteger = BigInteger.valueOf(Integer.parseInt(lowPrice));
                medPrice = String.valueOf(highPriceInteger.add(lowPriceInteger).divide(new BigInteger("2")));
            }
            if ((timeFrameValuesMapping = this.itemPriceMap.get(currentID = entry.getKey().intValue())) == null) {
                HashMap<CallSite, String> timeFrameValues = new HashMap<CallSite, String>();
                timeFrameValues.put((CallSite)((Object)(timePeriod + "Low")), lowPrice);
                timeFrameValues.put((CallSite)((Object)(timePeriod + "Med")), medPrice);
                timeFrameValues.put((CallSite)((Object)(timePeriod + "High")), highPrice);
                this.itemPriceMap.put(currentID, timeFrameValues);
                continue;
            }
            timeFrameValuesMapping.put(timePeriod + "Low", lowPrice);
            timeFrameValuesMapping.put(timePeriod + "Med", medPrice);
            timeFrameValuesMapping.put(timePeriod + "High", highPrice);
        }
    }

    public List<MarketWatcherItem> getItems() {
        return this.items;
    }

    public void setItems(List<MarketWatcherItem> items) {
        this.items = items;
    }

    public List<MarketWatcherTab> getTabs() {
        return this.tabs;
    }

    public void setTabs(List<MarketWatcherTab> tabs) {
        this.tabs = tabs;
    }

    public Map<Integer, Map<String, String>> getItemPriceMap() {
        return this.itemPriceMap;
    }

    public void setItemPriceMap(Map<Integer, Map<String, String>> itemPriceMap) {
        this.itemPriceMap = itemPriceMap;
    }
}

