/*
 * Decompiled with CFR 0.152.
 */
package com.trackscapeconnector;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.trackscapeconnector.dtos.DiscordChat;
import com.trackscapeconnector.dtos.WebSocketMessage;
import java.lang.reflect.Type;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketListener
extends okhttp3.WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketListener.class);
    private ClientThread clientThread;
    private Client client;
    public boolean socketConnected;
    public boolean socketConnecting = true;
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private final OkHttpClient okHttpClient;
    public WebSocket ws;
    private final Gson gson;
    private final int discordIconLocation;
    Type WebSocketDiscordMessage = new TypeToken<WebSocketMessage<DiscordChat>>(){}.getType();

    public WebSocketListener(Client gameClient, ClientThread gameClientThread, OkHttpClient okHttpClient, Gson gson, int DiscordIconLocation) {
        this.client = gameClient;
        this.clientThread = gameClientThread;
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        this.discordIconLocation = DiscordIconLocation;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        log.debug("Connected");
        this.socketConnecting = false;
        this.socketConnected = true;
    }

    public void onMessage(WebSocket webSocket, String jsonString) {
        WebSocketMessage data = (WebSocketMessage)this.gson.fromJson(jsonString, WebSocketMessage.class);
        if (data.message_type == WebSocketMessage.MessageType.ToClanChat) {
            WebSocketMessage discordMessage = (WebSocketMessage)this.gson.fromJson(jsonString, this.WebSocketDiscordMessage);
            this.handleDiscordChat((DiscordChat)discordMessage.message);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        webSocket.close(1000, null);
        log.debug("Closing: " + code + " " + reason);
        this.socketConnecting = false;
        this.socketConnected = false;
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        t.printStackTrace();
        this.socketConnecting = false;
        this.socketConnected = false;
    }

    private void handleDiscordChat(DiscordChat message) {
        this.clientThread.invokeLater(() -> {
            String clanName = this.client.getClanChannel().getName();
            String sender = String.format("<img=%d>%s", this.discordIconLocation, Text.toJagexName((String)message.sender));
            this.client.addChatMessage(ChatMessageType.CLAN_CHAT, sender, message.message, clanName, false);
        });
    }
}

