/*
 * Decompiled with CFR 0.152.
 */
package com.trackscapeconnector;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.trackscapeconnector.FindWordTypeService;
import com.trackscapeconnector.RemoteSubmitter;
import com.trackscapeconnector.TrackScapeConnectorConfig;
import com.trackscapeconnector.WebSocketListener;
import com.trackscapeconnector.dtos.ChatPayload;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.IndexedSprite;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TrackScape Connector")
public class TrackScapeConnectorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TrackScapeConnectorPlugin.class);
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private static final int WS_RECONNECT_CHECK_INTERVAL = 2;
    private static final Pattern ICON_PATTERN = Pattern.compile("<img=(\\d+)>");
    private static final String CLAN_WELCOME_TEXT = "To talk in your clan's channel, start each line of chat with // or /c.";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TrackScapeConnectorConfig config;
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;
    @Inject
    private WorldService worldService;
    private RemoteSubmitter remoteSubmitter;
    private WebSocketListener webSocketListener;
    public WebSocket ws;
    private int discordIconLocation = -1;
    private ScheduledExecutorService wsExecutorService;
    private FindWordTypeService findWordTypeService;

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getModIcons() == null) {
                return false;
            }
            this.loadIcon();
            return true;
        });
        this.startRemoteSubmitter();
        this.findWordTypeService = new FindWordTypeService(this.worldService, this.client);
    }

    protected void shutDown() throws Exception {
        this.stopWebsocket();
        this.shutdownRemoteSubmitter();
    }

    @Provides
    TrackScapeConnectorConfig provideConfig(ConfigManager configManager) {
        return (TrackScapeConnectorConfig)configManager.getConfig(TrackScapeConnectorConfig.class);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        switch (event.getType()) {
            case CLAN_CHAT: 
            case CLAN_MESSAGE: {
                if (Objects.equals(this.config.verificationCode(), "") || this.config.verificationCode() == null || Objects.equals(event.getName(), "") && Objects.equals(event.getSender(), "")) break;
                ClanChannel clanChannel = this.client.getClanChannel();
                String sender = "";
                boolean isLeagueWorld = false;
                sender = event.getType() == ChatMessageType.CLAN_MESSAGE ? clanChannel.getName() : Text.removeFormattingTags((String)Text.toJagexName((String)event.getName()));
                if (Objects.equals(sender, clanChannel.getName())) {
                    if (event.getMessage().equals(CLAN_WELCOME_TEXT)) break;
                    isLeagueWorld = this.findWordTypeService.isPlayerInLeaguesWorld(event.getMessage());
                }
                int iconId = IconID.NO_ENTRY.getIndex();
                Matcher matcher = ICON_PATTERN.matcher(event.getName());
                if (matcher.find()) {
                    iconId = Integer.parseInt(matcher.group(1));
                }
                String rank = this.GetMembersTitle(sender, clanChannel.getName());
                ChatPayload chatPayload = ChatPayload.from(clanChannel.getName(), sender, event.getMessage(), rank, iconId, isLeagueWorld);
                this.remoteSubmitter.queue(chatPayload);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("trackScapeconnectorplugin")) {
            this.shutdownRemoteSubmitter();
            this.startRemoteSubmitter();
            this.stopWebsocket();
            if (!this.config.allowMessagesFromDiscord()) {
                this.startWebsocket(this.config.webSocketEndpoint());
            }
        }
    }

    @Subscribe
    public void onClanChannelChanged(ClanChannelChanged event) {
        if (event.getClanId() == 0) {
            this.findWordTypeService.loadClanMembers();
            if (event.getClanChannel() == null) {
                this.shutdownRemoteSubmitter();
                this.stopWebsocket();
            } else {
                if (this.config.allowMessagesFromDiscord()) {
                    this.stopWebsocket();
                    this.startWebsocket(this.config.webSocketEndpoint());
                }
                this.remoteSubmitter = null;
                this.startRemoteSubmitter();
            }
        }
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) {
        String channelName = event.getClanChannel().getName();
        if (!Objects.equals(channelName, this.client.getClanChannel().getName())) {
            return;
        }
        this.findWordTypeService.CLAN_MEMBER_NAMES.add(event.getClanMember().getName());
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft event) {
        String channelName = event.getClanChannel().getName();
        if (!Objects.equals(channelName, this.client.getClanChannel().getName())) {
            return;
        }
        this.findWordTypeService.CLAN_MEMBER_NAMES.remove(event.getClanMember().getName());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.shutdownRemoteSubmitter();
            this.stopWebsocket();
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.findWordTypeService.loadWorldTypes();
        }
    }

    private void startRemoteSubmitter() {
        if (this.remoteSubmitter != null) {
            log.debug("Shutting down previous remoteSubmitter...");
            this.shutdownRemoteSubmitter();
        }
        log.debug("Starting a new remoteSubmitter...");
        this.remoteSubmitter = RemoteSubmitter.create(this.httpClient, this.gson, this.config.httpApiEndpoint(), this.config.verificationCode());
        this.remoteSubmitter.initialize();
    }

    private void shutdownRemoteSubmitter() {
        if (this.remoteSubmitter != null) {
            this.remoteSubmitter.shutdown();
            this.remoteSubmitter = null;
        }
    }

    private String GetMembersTitle(String name, String clanName) {
        ClanChannelMember member;
        String cleanName = Text.removeTags((String)name);
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null && (member = clanChannel.findMember(cleanName)) != null && clanChannel.getName().equals(clanName)) {
            String clanTitle;
            ClanRank rank = member.getRank();
            ClanSettings clanSettings = this.client.getClanSettings();
            if (clanSettings != null && (clanTitle = clanSettings.titleForRank(rank).getName()) != null) {
                return clanTitle;
            }
        }
        return "Guest";
    }

    public void startWebsocket(String host) {
        log.debug("Connecting...");
        Request request = new Request.Builder().url(host).addHeader("verification-code", this.config.verificationCode()).build();
        this.webSocketListener = new WebSocketListener(this.client, this.clientThread, this.httpClient, this.gson, this.discordIconLocation);
        this.ws = this.httpClient.newWebSocket(request, (okhttp3.WebSocketListener)this.webSocketListener);
        this.wsExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.wsExecutorService.scheduleAtFixedRate(this::checkWebSocketConnection, 2L, 2L, TimeUnit.MINUTES);
    }

    public void stopWebsocket() {
        if (this.ws != null) {
            this.ws.close(1000, null);
            if (this.wsExecutorService != null) {
                this.wsExecutorService.shutdown();
            }
            this.wsExecutorService = null;
        }
        this.webSocketListener = null;
    }

    private void checkWebSocketConnection() {
        if (this.webSocketListener.socketConnected || this.webSocketListener.socketConnecting) {
            return;
        }
        this.stopWebsocket();
        this.startWebsocket(this.config.webSocketEndpoint());
    }

    private void loadIcon() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.discordIconLocation != -1 || modIcons == null) {
            return;
        }
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/discord-mark-blue-smaller.png");
        IndexedSprite indexedSprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        this.discordIconLocation = modIcons.length;
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + 1);
        newModIcons[newModIcons.length - 1] = indexedSprite;
        this.client.setModIcons(newModIcons);
    }
}

