/*
 * Decompiled with CFR 0.152.
 */
package com.trackscapeconnector;

import com.google.gson.Gson;
import com.trackscapeconnector.dtos.ChatPayload;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSubmitter {
    private static final Logger log = LoggerFactory.getLogger(RemoteSubmitter.class);
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private static final int MAX_ENTRIES_PER_TICK = 30;
    private static final int TICK_INTERVAL = 2;
    private static final CircuitBreaker<Object> BREAKER = ((CircuitBreaker)new CircuitBreaker().handle((Class<? extends Throwable>)((Class<Throwable>)IOException.class))).withDelay(Duration.ofMinutes(5L)).withFailureThreshold(3, Duration.ofSeconds(30L)).onHalfOpen(RemoteSubmitter::onHalfOpen);
    private final ConcurrentLinkedDeque<ChatPayload> queuedEntries = new ConcurrentLinkedDeque();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final OkHttpClient okHttpClient;
    private final Gson gson;
    private final String sendClanChatsEndpoint;
    private final String VerificationCode;

    private RemoteSubmitter(OkHttpClient okHttpClient, Gson gson, String sendClanChatsEndpoint, String verificationCode) {
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        this.sendClanChatsEndpoint = sendClanChatsEndpoint;
        this.VerificationCode = verificationCode;
    }

    public static RemoteSubmitter create(OkHttpClient okHttpClient, Gson gson, String remoteServerRootEndpoint, String verificationCode) {
        return new RemoteSubmitter(okHttpClient, gson, remoteServerRootEndpoint, verificationCode);
    }

    private static void onHalfOpen() {
        log.info("Checking if remote host is answering properly again (HALF_OPEN)");
    }

    public void initialize() {
        this.executorService.scheduleAtFixedRate(this::processQueue, 2L, 2L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void queue(ChatPayload entry) {
        this.queuedEntries.add(entry);
    }

    private void processQueue() {
        block3: {
            if (this.queuedEntries.isEmpty()) {
                return;
            }
            RequestBody payload = this.buildPayload();
            payload.contentType();
            try {
                Failsafe.with((Policy[])new CircuitBreaker[]{BREAKER}).run(() -> {
                    Request request = new Request.Builder().url(this.sendClanChatsEndpoint).addHeader("verification-code", this.VerificationCode).post(payload).build();
                    try (Response response = this.okHttpClient.newCall(request).execute();){
                        if (!response.isSuccessful()) {
                            log.warn("Remote endpoint returned non successful response, responseCode={}", (Object)response.code());
                            log.warn("Response body: {}", (Object)response.body().string());
                        }
                    }
                });
            }
            catch (Exception e) {
                if (BREAKER.isOpen()) break block3;
                log.warn("Failed to submit chat entries: {}", (Object)e.getMessage());
            }
        }
    }

    private RequestBody buildPayload() {
        ArrayList<ChatPayload> entries = new ArrayList<ChatPayload>();
        for (int count = 0; !this.queuedEntries.isEmpty() && count < 30; ++count) {
            entries.add(this.queuedEntries.poll());
        }
        String json = this.gson.toJson(entries);
        return RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
    }
}

