/*
 * Decompiled with CFR 0.152.
 */
package com.trackscapeconnector;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.client.game.WorldService;
import net.runelite.client.util.Text;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

public class FindWordTypeService {
    public final Set<String> CLAN_MEMBER_NAMES = new HashSet<String>();
    private Set<Integer> LEAGUE_WORLDS = new HashSet<Integer>();
    private WorldService worldService;
    private Client client;

    public FindWordTypeService(WorldService worldService, Client client) {
        this.worldService = worldService;
        this.client = client;
    }

    public void loadWorldTypes() {
        this.LEAGUE_WORLDS = this.worldService.getWorlds().getWorlds().stream().filter(world -> world.getTypes().contains(WorldType.SEASONAL)).map(World::getId).collect(Collectors.toSet());
    }

    public void loadClanMembers() {
        if (this.client.getClanChannel() == null) {
            return;
        }
        Set clanMates = this.client.getClanChannel().getMembers().stream().map(ClanChannelMember::getName).map(Text::toJagexName).collect(Collectors.toSet());
        this.CLAN_MEMBER_NAMES.addAll(clanMates);
    }

    public boolean isPlayerInLeaguesWorld(String message) {
        String cleanMessage = Text.sanitize((String)message);
        Optional<String> possibleClanmateName = this.CLAN_MEMBER_NAMES.stream().filter(cleanMessage::startsWith).findAny();
        if (possibleClanmateName.isEmpty()) {
            return false;
        }
        String clanmateName = possibleClanmateName.get();
        ClanChannel clan = this.client.getClanChannel();
        assert (clan != null);
        ClanChannelMember possibleClanMember = clan.findMember(clanmateName);
        assert (possibleClanMember != null);
        return this.LEAGUE_WORLDS.contains(possibleClanMember.getWorld());
    }
}

