/*
 * Decompiled with CFR 0.152.
 */
package com.tempoross;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.tempoross.DrawObject;
import com.tempoross.TemporossConfig;
import com.tempoross.TemporossInfoBox;
import com.tempoross.TemporossOverlay;
import com.tempoross.TimerSwaps;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Tempoross", description="Useful information and tracking for the Tempoross skilling boss")
public class TemporossPlugin
extends Plugin {
    private static final String WAVE_INCOMING_MESSAGE = "a colossal wave closes in...";
    private static final String WAVE_END_SAFE = "as the wave washes over you";
    private static final String WAVE_END_DANGEROUS = "the wave slams into you";
    private static final String TEMPOROSS_VULNERABLE_MESSAGE = "tempoross is vulnerable";
    private static final int VARB_IS_TETHERED = 11895;
    private static final int VARB_REWARD_POOL_NUMBER = 11936;
    private static final int TEMPOROSS_REGION = 12078;
    private static final int UNKAH_REWARD_POOL_REGION = 12588;
    private static final int UNKAH_BOAT_REGION = 12332;
    private static final int DAMAGE_PER_UNCOOKED = 10;
    private static final int DAMAGE_PER_COOKED = 15;
    private static final int DAMAGE_PER_CRYSTAL = 10;
    private static final int REWARD_POOL_IMAGE_ID = 25574;
    private static final int DAMAGE_IMAGE_ID = 21028;
    private static final int FISH_IMAGE_ID = 25565;
    private static final int NET_IMAGE_ID = 6674;
    private static final BufferedImage PHASE_IMAGE = ImageUtil.loadImageResource(TemporossPlugin.class, (String)"phases.png");
    private static final int FIRE_ID = 37582;
    private static final int FIRE_SPREAD_MILLIS = 24000;
    private static final int FIRE_SPAWN_MILLIS = 9600;
    private static final int FIRE_SPREADING_SPAWN_MILLIS = 1200;
    private static final int WAVE_IMPACT_MILLIS = 7800;
    public static final int TEMPOROSS_HUD_UPDATE = 4075;
    public static final int STORM_INTENSITY = 350;
    public static final int MAX_STORM_INTENSITY = 350;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TemporossConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private TemporossOverlay temporossOverlay;
    private final Set<Integer> TEMPOROSS_GAMEOBJECTS = ImmutableSet.of((Object)37582, (Object)41006, (Object)41007, (Object)41352, (Object)41353, (Object)41354, (Object[])new Integer[]{41355, 40996, 40997, 41010, 41011});
    private final Map<GameObject, DrawObject> gameObjects = new WeakHashMap<GameObject, DrawObject>();
    private final Map<NPC, Long> npcs = new IdentityHashMap<NPC, Long>();
    private final Map<GameObject, DrawObject> totemMap = new WeakHashMap<GameObject, DrawObject>();
    private TemporossInfoBox rewardInfoBox;
    private TemporossInfoBox fishInfoBox;
    private TemporossInfoBox totalFishInfoBox;
    private TemporossInfoBox damageInfoBox;
    private TemporossInfoBox phaseInfoBox;
    private boolean waveIsIncoming;
    private boolean nearRewardPool;
    private int previousRegion;
    private int phase = 1;
    private int uncookedFish = 0;
    private int cookedFish = 0;
    private int crystalFish = 0;
    private Instant waveIncomingStartTime;

    @Provides
    TemporossConfig provideConfig(ConfigManager configManager) {
        return (TemporossConfig)configManager.getConfig(TemporossConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.temporossOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.temporossOverlay);
        this.reset();
        this.removeRewardInfoBox();
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        int duration;
        if (!this.TEMPOROSS_GAMEOBJECTS.contains(gameObjectSpawned.getGameObject().getId())) {
            return;
        }
        switch (gameObjectSpawned.getGameObject().getId()) {
            case 37582: {
                duration = 24000;
                break;
            }
            case 41006: {
                if (this.config.fireNotification()) {
                    this.notifier.notify("A strong wind blows as clouds roll in...");
                }
                duration = 9600;
                break;
            }
            case 41007: {
                duration = 1200;
                break;
            }
            default: {
                this.totemMap.put(gameObjectSpawned.getGameObject(), new DrawObject(gameObjectSpawned.getTile(), Instant.now(), 7800, this.config.waveTimerColor()));
                if (this.waveIsIncoming && this.config.useWaveTimer() != TimerSwaps.TimerModes.OFF) {
                    this.addTotemTimers(false);
                }
                return;
            }
        }
        this.gameObjects.put(gameObjectSpawned.getGameObject(), new DrawObject(gameObjectSpawned.getTile(), Instant.now(), duration, this.config.fireColor()));
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        this.gameObjects.remove(gameObjectDespawned.getGameObject());
        this.totemMap.remove(gameObjectDespawned.getGameObject());
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        int ninetyPercentOfMaxStormIntensity;
        int currentStormIntensity;
        if (!this.config.stormIntensityNotification() || scriptPreFired.getScriptId() != 4075) {
            return;
        }
        int[] stack = this.client.getIntStack();
        if (stack[0] == 350 && (currentStormIntensity = stack[1]) > (ninetyPercentOfMaxStormIntensity = 315) && currentStormIntensity < ninetyPercentOfMaxStormIntensity + 3) {
            this.notifier.notify("You are running out of time!");
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (10569 == npcSpawned.getNpc().getId()) {
            if (this.config.highlightDoubleSpot()) {
                this.npcs.put(npcSpawned.getNpc(), Instant.now().toEpochMilli());
            }
            if (this.config.doubleSpotNotification()) {
                this.notifier.notify("A double Harpoonfish spot has appeared.");
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        this.npcs.remove(npcDespawned.getNpc());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOADING) {
            this.reset();
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        int region = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (region != 12078 && this.previousRegion == 12078) {
            this.reset();
        } else if (region == 12078 && this.previousRegion != 12078) {
            this.setup();
        }
        boolean bl = this.nearRewardPool = region == 12332 || region == 12588;
        if (this.nearRewardPool) {
            this.addRewardInfoBox();
        } else {
            this.removeRewardInfoBox();
        }
        this.previousRegion = region;
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.nearRewardPool) {
            this.addRewardInfoBox();
        }
        if (this.waveIsIncoming && this.config.useWaveTimer() != TimerSwaps.TimerModes.OFF) {
            this.addTotemTimers(false);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = chatMessage.getMessage().toLowerCase();
        if (message.contains(WAVE_INCOMING_MESSAGE)) {
            this.waveIsIncoming = true;
            this.addTotemTimers(true);
            if (this.config.waveNotification()) {
                this.notifier.notify("A colossal wave closes in...");
            }
        } else if (message.contains(WAVE_END_SAFE) || message.contains(WAVE_END_DANGEROUS)) {
            this.waveIsIncoming = false;
            this.removeTotemTimers();
        } else if (message.contains(TEMPOROSS_VULNERABLE_MESSAGE)) {
            ++this.phase;
            this.redrawInfoBoxes();
            if (this.config.vulnerableNotification()) {
                this.notifier.notify("Tempoross is vulnerable.");
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId() || !this.config.fishIndicator() && !this.config.damageIndicator() || this.fishInfoBox == null && this.damageInfoBox == null) {
            return;
        }
        ItemContainer inventory = event.getItemContainer();
        this.uncookedFish = inventory.count(25564);
        this.cookedFish = inventory.count(25565);
        this.crystalFish = inventory.count(25566);
        this.redrawInfoBoxes();
    }

    public void addTotemTimers(boolean setStart) {
        if (setStart && !this.totemMap.isEmpty()) {
            this.waveIncomingStartTime = Instant.now();
        }
        Instant start = this.waveIncomingStartTime;
        boolean tethered = this.client.getVarbitValue(11895) > 0;
        this.totemMap.forEach((object, drawObject) -> {
            Color color;
            if (tethered) {
                color = this.config.tetheredColor();
            } else {
                switch (object.getId()) {
                    case 40996: 
                    case 40997: 
                    case 41010: 
                    case 41011: {
                        color = this.config.poleBrokenColor();
                        break;
                    }
                    default: {
                        color = this.config.waveTimerColor();
                    }
                }
            }
            drawObject.setStartTime(start);
            drawObject.setColor(color);
            this.gameObjects.put((GameObject)object, (DrawObject)drawObject);
        });
    }

    public void removeTotemTimers() {
        this.gameObjects.keySet().removeAll(this.totemMap.keySet());
    }

    private TemporossInfoBox createInfobox(BufferedImage image, String text, String tooltip) {
        TemporossInfoBox infoBox = new TemporossInfoBox(image, this);
        infoBox.setText(text);
        infoBox.setTooltip(tooltip);
        return infoBox;
    }

    public void addRewardInfoBox() {
        int rewardPoints = this.client.getVarbitValue(11936);
        this.infoBoxManager.removeInfoBox((InfoBox)this.rewardInfoBox);
        this.rewardInfoBox = this.createInfobox((BufferedImage)this.itemManager.getImage(25574), Integer.toString(rewardPoints), rewardPoints + " Reward Point" + (rewardPoints == 1 ? "" : "s"));
        this.infoBoxManager.addInfoBox((InfoBox)this.rewardInfoBox);
    }

    public void removeRewardInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.rewardInfoBox);
        this.rewardInfoBox = null;
    }

    public void addFishInfoBox(String text, String tooltip) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.fishInfoBox);
        this.fishInfoBox = this.createInfobox((BufferedImage)this.itemManager.getImage(25565), text, tooltip);
        this.infoBoxManager.addInfoBox((InfoBox)this.fishInfoBox);
    }

    public void addTotalFishInfoBox(String text, String tooltip) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.totalFishInfoBox);
        this.totalFishInfoBox = this.createInfobox((BufferedImage)this.itemManager.getImage(6674), text, tooltip);
        this.infoBoxManager.addInfoBox((InfoBox)this.totalFishInfoBox);
    }

    public void removeFishInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.fishInfoBox);
        this.fishInfoBox = null;
    }

    public void removeTotalFishInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.totalFishInfoBox);
        this.totalFishInfoBox = null;
    }

    public void addDamageInfoBox(int damage) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.damageInfoBox);
        this.damageInfoBox = this.createInfobox((BufferedImage)this.itemManager.getImage(21028), Integer.toString(damage), "Damage: " + damage);
        this.infoBoxManager.addInfoBox((InfoBox)this.damageInfoBox);
    }

    public void removeDamageInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.damageInfoBox);
        this.damageInfoBox = null;
    }

    public void addPhaseInfoBox(int phase) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.phaseInfoBox);
        this.phaseInfoBox = this.createInfobox(PHASE_IMAGE, Integer.toString(phase), "Phase " + phase);
        this.infoBoxManager.addInfoBox((InfoBox)this.phaseInfoBox);
    }

    public void removePhaseInfoBox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.phaseInfoBox);
        this.phaseInfoBox = null;
    }

    public void reset() {
        this.removeFishInfoBox();
        this.removeDamageInfoBox();
        this.removePhaseInfoBox();
        this.removeTotalFishInfoBox();
        this.npcs.clear();
        this.totemMap.clear();
        this.gameObjects.clear();
        this.waveIsIncoming = false;
        this.phase = 1;
        this.uncookedFish = 0;
        this.cookedFish = 0;
        this.crystalFish = 0;
    }

    public void setup() {
        this.redrawInfoBoxes();
    }

    private void redrawInfoBoxes() {
        if (this.config.phaseIndicator()) {
            this.addPhaseInfoBox(this.phase);
        }
        if (this.config.damageIndicator()) {
            int damage = this.uncookedFish * 10 + this.cookedFish * 15 + this.crystalFish * 10;
            this.addDamageInfoBox(damage);
        }
        if (this.config.fishIndicator()) {
            this.addFishInfoBox(this.uncookedFish + this.crystalFish + "/" + this.cookedFish, "Uncooked Fish: " + (this.uncookedFish + this.crystalFish) + "</br>Cooked Fish: " + this.cookedFish);
            this.addTotalFishInfoBox("" + (this.uncookedFish + this.crystalFish + this.cookedFish), "Total: " + (this.uncookedFish + this.crystalFish + this.cookedFish));
        }
    }

    public Map<GameObject, DrawObject> getGameObjects() {
        return this.gameObjects;
    }

    public Map<NPC, Long> getNpcs() {
        return this.npcs;
    }
}

