/*
 * Decompiled with CFR 0.152.
 */
package com.tempoross;

import com.google.common.collect.ImmutableSet;
import com.tempoross.DrawObject;
import com.tempoross.TemporossConfig;
import com.tempoross.TemporossPlugin;
import com.tempoross.TimerSwaps;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.time.Instant;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import net.runelite.client.ui.overlay.components.TextComponent;

class TemporossOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 3000;
    private static final int PIE_DIAMETER = 20;
    private static final float DOUBLE_SPOT_MOVE_MILLIS = 24000.0f;
    private static final int FIRE_ID = 37582;
    private final Set<Integer> FIRE_GAMEOBJECTS = ImmutableSet.of((Object)37582, (Object)41006, (Object)41007);
    private final Set<Integer> TETHER_GAMEOBJECTS = ImmutableSet.of((Object)41352, (Object)41353, (Object)41354, (Object)41355, (Object)40996, (Object)40997, (Object[])new Integer[]{41010, 41011});
    private final Client client;
    private final TemporossPlugin plugin;
    private final TemporossConfig config;
    private final TextComponent textComponent = new TextComponent();

    @Inject
    private TemporossOverlay(Client client, TemporossPlugin plugin, TemporossConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return null;
        }
        LocalPoint playerLocation = localPlayer.getLocalLocation();
        Instant now = Instant.now();
        this.highlightGameObjects(graphics, playerLocation, now);
        this.highlightNpcs(graphics, playerLocation, now);
        return null;
    }

    private void highlightGameObjects(Graphics2D graphics, LocalPoint playerLocation, Instant now) {
        int plane = this.client.getPlane();
        TimerSwaps.TimerModes highlightFires = this.config.highlightFires();
        TimerSwaps.TimerModes waveTimer = this.config.useWaveTimer();
        this.plugin.getGameObjects().forEach((object, drawObject) -> {
            Polygon poly;
            Tile tile = drawObject.getTile();
            if (tile.getPlane() == plane && tile.getLocalLocation().distanceTo(playerLocation) < 3000 && (poly = object.getCanvasTilePoly()) != null) {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)drawObject.getColor());
            }
            if (drawObject.getDuration() <= 0 || object.getCanvasLocation() == null) {
                return;
            }
            if (highlightFires != TimerSwaps.TimerModes.OFF && this.FIRE_GAMEOBJECTS.contains(object.getId())) {
                if (tile.getLocalLocation().distanceTo(playerLocation) >= 3000) {
                    return;
                }
                if (highlightFires == TimerSwaps.TimerModes.SECONDS || highlightFires == TimerSwaps.TimerModes.TICKS) {
                    long waveTimerMillis = drawObject.getStartTime().toEpochMilli() + (long)drawObject.getDuration() - now.toEpochMilli();
                    waveTimerMillis = (waveTimerMillis % (long)drawObject.getDuration() + (long)drawObject.getDuration()) % (long)drawObject.getDuration();
                    this.renderTextElement((GameObject)object, (DrawObject)drawObject, waveTimerMillis, graphics, highlightFires);
                } else if (highlightFires == TimerSwaps.TimerModes.PIE) {
                    this.renderPieElement((GameObject)object, (DrawObject)drawObject, now, graphics);
                }
            } else if (waveTimer != TimerSwaps.TimerModes.OFF && this.TETHER_GAMEOBJECTS.contains(object.getId())) {
                if (tile.getLocalLocation().distanceTo(playerLocation) >= 3000) {
                    return;
                }
                if (waveTimer == TimerSwaps.TimerModes.SECONDS || waveTimer == TimerSwaps.TimerModes.TICKS) {
                    long waveTimerMillis = drawObject.getStartTime().toEpochMilli() + (long)drawObject.getDuration() - now.toEpochMilli();
                    this.renderTextElement((GameObject)object, (DrawObject)drawObject, waveTimerMillis, graphics, waveTimer);
                } else if (waveTimer == TimerSwaps.TimerModes.PIE) {
                    this.renderPieElement((GameObject)object, (DrawObject)drawObject, now, graphics);
                }
            }
        });
    }

    private void highlightNpcs(Graphics2D graphics, LocalPoint playerLocation, Instant now) {
        this.plugin.getNpcs().forEach((npc, startTime) -> {
            NPCComposition npcComposition = npc.getComposition();
            int size = npcComposition.getSize();
            LocalPoint lp = npc.getLocalLocation();
            Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size);
            if (tilePoly != null && lp.distanceTo(playerLocation) < 3000) {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)tilePoly, (Color)this.config.doubleSpotColor());
            }
            if (lp.distanceTo(playerLocation) < 3000) {
                float percent = (float)(now.toEpochMilli() - startTime) / 24000.0f;
                ProgressPieComponent ppc = new ProgressPieComponent();
                ppc.setBorderColor(this.config.doubleSpotColor());
                ppc.setFill(this.config.doubleSpotColor());
                ppc.setProgress((double)percent);
                ppc.setDiameter(20);
                ppc.setPosition(Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)this.client.getPlane()));
                ppc.render(graphics);
            }
        });
    }

    private void renderTextElement(GameObject gameObject, DrawObject drawObject, long timerMillis, Graphics2D graphics, TimerSwaps.TimerModes timerMode) {
        String timerText = timerMode == TimerSwaps.TimerModes.SECONDS ? String.format("%.1f", Float.valueOf((float)timerMillis / 1000.0f)) : String.format("%d", timerMillis / 600L);
        this.textComponent.setText(timerText);
        this.textComponent.setColor(drawObject.getColor());
        this.textComponent.setPosition(new Point(gameObject.getCanvasLocation().getX(), gameObject.getCanvasLocation().getY()));
        this.textComponent.render(graphics);
    }

    private void renderPieElement(GameObject gameObject, DrawObject drawObject, Instant now, Graphics2D graphics) {
        float percent = (float)((now.toEpochMilli() - drawObject.getStartTime().toEpochMilli()) % (long)drawObject.getDuration()) / (float)drawObject.getDuration();
        ProgressPieComponent ppc = new ProgressPieComponent();
        ppc.setBorderColor(drawObject.getColor());
        ppc.setFill(drawObject.getColor());
        ppc.setProgress((double)percent);
        ppc.setDiameter(20);
        ppc.setPosition(gameObject.getCanvasLocation());
        ppc.render(graphics);
    }
}

