/*
 * Decompiled with CFR 0.152.
 */
package im2be.afkcountdown;

import com.google.inject.Provides;
import im2be.afkcountdown.AfkCountdownConfig;
import im2be.afkcountdown.AfkCountdownOverlay;
import im2be.afkcountdown.AfkCountdownTimer;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK Countdown", description="Shows you exactly how many seconds it will take before you log out due to inactivity", tags={"afk", "timer", "countdown", "log", "logout"})
public class AfkCountdownPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkCountdownPlugin.class);
    @Inject
    private Client client;
    private AfkCountdownTimer currentTimer;
    Instant timerStartTime;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private AfkCountdownOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AfkCountdownConfig config;
    private static final BufferedImage LOGOUT_IMAGE = ImageUtil.loadImageResource(AfkCountdownPlugin.class, (String)"logout_icon.png");
    private boolean active = false;
    private long lastIdleDuration = -1L;

    protected void startUp() throws Exception {
        this.active = true;
        if (this.config.renderOnLogoutStone()) {
            this.overlayManager.add((Overlay)this.overlay);
        }
    }

    protected void shutDown() throws Exception {
        this.active = false;
        this.lastIdleDuration = -1L;
        this.removeTimer();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"AfkCountdown".equals(event.getGroup())) {
            return;
        }
        if ("renderOnLogoutStone".equals(event.getKey())) {
            if (this.config.renderOnLogoutStone()) {
                this.overlayManager.add((Overlay)this.overlay);
                this.removeTimer();
            } else {
                this.overlayManager.remove((Overlay)this.overlay);
                this.setTimer(Duration.ofMillis(this.getDurationMillis()));
            }
        }
    }

    private long getDurationMillis() {
        return 20 * (this.client.getIdleTimeout() - this.getIdleTicks()) + 999;
    }

    @Provides
    AfkCountdownConfig provideConfig(ConfigManager configManager) {
        return (AfkCountdownConfig)configManager.getConfig(AfkCountdownConfig.class);
    }

    private int getIdleTicks() {
        return Math.min(this.client.getKeyboardIdleTicks(), this.client.getMouseIdleTicks());
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (!this.active) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        long durationMillis = this.getDurationMillis();
        if (durationMillis < 0L) {
            return;
        }
        if (this.lastIdleDuration == -1L || durationMillis < this.lastIdleDuration) {
            if (durationMillis >= 0L) {
                this.setTimer(Duration.ofMillis(durationMillis));
                this.overlay.setTimer(durationMillis);
            } else {
                this.removeTimer();
            }
        }
        this.lastIdleDuration = durationMillis;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.removeTimer();
            this.lastIdleDuration = -1L;
        }
    }

    private void removeTimer() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.currentTimer);
        this.currentTimer = null;
        this.timerStartTime = null;
    }

    private void setTimer(Duration duration) {
        if (this.config.renderOnLogoutStone()) {
            return;
        }
        Instant now = Instant.now();
        if (this.currentTimer == null) {
            this.currentTimer = new AfkCountdownTimer(duration, LOGOUT_IMAGE, this);
            this.timerStartTime = now;
            this.infoBoxManager.addInfoBox((InfoBox)this.currentTimer);
        } else {
            Duration newDuration = duration.plus(Duration.between(this.timerStartTime, now));
            this.currentTimer.setDuration(newDuration);
        }
    }

    public AfkCountdownTimer getCurrentTimer() {
        return this.currentTimer;
    }

    public Instant getTimerStartTime() {
        return this.timerStartTime;
    }
}

