/*
 * Decompiled with CFR 0.152.
 */
package im2be.afkcountdown;

import im2be.afkcountdown.AfkCountdownConfig;
import im2be.afkcountdown.AfkCountdownPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.FontType;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfkCountdownOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(AfkCountdownOverlay.class);
    private final Client client;
    private final AfkCountdownConfig config;
    private final ConfigManager configManager;
    private Instant endTime;

    @Inject
    public AfkCountdownOverlay(Client client, AfkCountdownPlugin plugin, AfkCountdownConfig config, ConfigManager configManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGH);
        this.client = client;
        this.config = config;
        this.configManager = configManager;
    }

    public Dimension render(Graphics2D graphics) {
        Widget toDrawOn;
        if (!this.config.renderOnLogoutStone()) {
            return null;
        }
        if (this.client.isResized()) {
            toDrawOn = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_LOGOUT_TAB);
            if (toDrawOn == null || toDrawOn.isHidden()) {
                toDrawOn = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_INVENTORY_PARENT);
            }
            if (toDrawOn == null || toDrawOn.isHidden()) {
                toDrawOn = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_LOGOUT_BUTTON);
            }
        } else {
            toDrawOn = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_LOGOUT_TAB);
        }
        if (toDrawOn == null || toDrawOn.isHidden()) {
            return null;
        }
        Duration timeLeft = Duration.between(Instant.now(), this.endTime);
        if (timeLeft.isNegative()) {
            return null;
        }
        String textToDraw = this.textFrom(timeLeft);
        FontType infoboxFontType = (FontType)this.configManager.getConfiguration("runelite", "infoboxFontType", FontType.class);
        graphics.setFont(infoboxFontType.getFont());
        Rectangle bounds = toDrawOn.getBounds();
        Point drawLocation = new Point((int)bounds.getCenterX() - graphics.getFontMetrics().stringWidth(textToDraw) / 2, (int)bounds.getMaxY());
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)drawLocation, (String)textToDraw, (Color)this.textColor(timeLeft));
        return null;
    }

    public void setTimer(long period) {
        this.endTime = Instant.now().plus(Duration.of(period, ChronoUnit.MILLIS));
    }

    private Color textColor(Duration timeLeft) {
        if (timeLeft.getSeconds() < 60L) {
            return Color.RED.brighter();
        }
        return Color.WHITE;
    }

    private String textFrom(Duration duration) {
        int seconds = (int)(duration.toMillis() / 1000L);
        int minutes = seconds % 3600 / 60;
        int secs = seconds % 60;
        return String.format("%d:%02d", minutes, secs);
    }
}

