/*
 * Decompiled with CFR 0.152.
 */
package com.NPCOverheadDialogue.dialog;

import com.NPCOverheadDialogue.dialog.DialogCategories;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

public enum DialogNpc {
    CLEANER("Cleaner", -1, DialogCategories.CLEANER),
    DRAKE("Drake", 2004, DialogCategories.DUCKS),
    DUCK("Duck", -1, DialogCategories.DUCKS),
    DUCKLING("Duckling", -1, DialogCategories.DUCKS),
    ADAMANT_DRAGON("Adamant dragon", -1, DialogCategories.DRAGONS),
    BABY_BLACK_DRAGON("Baby black dragon", -1, DialogCategories.DRAGONS),
    BABY_BLUE_DRAGON("Baby blue dragon", -1, DialogCategories.DRAGONS),
    BABY_GREEN_DRAGON("Baby green dragon", -1, DialogCategories.DRAGONS),
    BABY_RED_DRAGON("Baby red dragon", -1, DialogCategories.DRAGONS),
    BLACK_DRAGON("Black dragon", -1, DialogCategories.DRAGONS),
    BLUE_DRAGON("Blue dragon", -1, DialogCategories.DRAGONS),
    BRONZE_DRAGON("Bronze dragon", -1, DialogCategories.DRAGONS),
    BRUTAL_BLACK_DRAGON("Brutal black dragon", -1, DialogCategories.DRAGONS),
    BRUTAL_BLUE_DRAGON("Brutal blue dragon", -1, DialogCategories.DRAGONS),
    BRUTAL_GREEN_DRAGON("Brutal green dragon", -1, DialogCategories.DRAGONS),
    BRUTAL_RED_DRAGON("Brutal red dragon", -1, DialogCategories.DRAGONS),
    CORRUPTED_DRAGON("Corrupted dragon", -1, DialogCategories.DRAGONS),
    CRYSTALLINE_DRAGON("Crystalline dragon", -1, DialogCategories.DRAGONS),
    DRAKE_DRAGON("Drake", -1, DialogCategories.DRAGONS),
    GREEN_DRAGON("Green dragon", -1, DialogCategories.DRAGONS),
    IRON_DRAGON("Iron dragon", -1, DialogCategories.DRAGONS),
    LAVA_DRAGON("Lava dragon", -1, DialogCategories.DRAGONS),
    MITHRIL_DRAGON("Mithril dragon", -1, DialogCategories.DRAGONS),
    REANIMATED_DRAGON("Reanimated dragon", -1, DialogCategories.DRAGONS),
    RED_DRAGON("Red dragon", -1, DialogCategories.DRAGONS),
    RUNE_DRAGON("Rune dragon", -1, DialogCategories.DRAGONS),
    STEEL_DRAGON("Steel dragon", -1, DialogCategories.DRAGONS),
    FISHING_SPOT("Fishing spot", -1, DialogCategories.FISHING_SPOT),
    ROD_FISHING_SPOT("Rod Fishing spot", -1, DialogCategories.FISHING_SPOT),
    BLACK_SWAN("Black swan", -1, DialogCategories.HONKING_BIRDS),
    CORMORANT("Cormorant", -1, DialogCategories.HONKING_BIRDS),
    GOOSE("Goose", -1, DialogCategories.HONKING_BIRDS),
    SWAN("Swan", -1, DialogCategories.HONKING_BIRDS),
    RELDO("Reldo", -1, DialogCategories.LIBRARIAN),
    LENNY("Lenny", -1, DialogCategories.LENNY),
    BABY_MOLE("Baby Mole", -1, DialogCategories.MID_SIZED_RODENTS),
    RABBIT("Rabbit", -1, DialogCategories.MID_SIZED_RODENTS),
    RED_PANDA("Red Panda", -1, DialogCategories.MID_SIZED_RODENTS),
    SQUIRREL("Squirrel", -1, DialogCategories.MID_SIZED_RODENTS),
    PIG("Pig", -1, DialogCategories.PIGS),
    PIGLET("Piglet", -1, DialogCategories.PIGS),
    GIANT_RAT("Giant rat", -1, DialogCategories.RATS),
    RAT("Rat", -1, DialogCategories.RATS),
    GULLS("Gull", -1, DialogCategories.SEAGULLS),
    PELICAN("Pelican", -1, DialogCategories.SEAGULLS),
    SEAGULL("Seagull", -1, DialogCategories.SEAGULLS),
    GARGOYLE("Gargoyle", -1, DialogCategories.SKELETONS),
    SKELETON("Skeleton", -1, DialogCategories.SKELETONS);

    private final String npcName;
    private final int npcID;
    private final DialogCategories[] dialogCategories;
    private static final Map<String, DialogNpc> NAME_MAP;

    private DialogNpc(String npcName, int npcID, DialogCategories ... dialogCategories) {
        this.npcName = npcName;
        this.npcID = npcID;
        this.dialogCategories = dialogCategories;
    }

    public static boolean isDialogNpc(String npcName) {
        return NAME_MAP.containsKey(npcName.toUpperCase());
    }

    @Nullable
    public static DialogNpc getDialogNpcsByNpcName(String npcName) {
        return NAME_MAP.get(npcName.toUpperCase());
    }

    @Nullable
    public static DialogNpc getDialogNpcsByNpcID(int npcID) {
        return NAME_MAP.get(Integer.toString(npcID));
    }

    @Nullable
    public String[] getAmbientDialogs() {
        Object[] dialogs = new String[]{};
        for (DialogCategories category : this.dialogCategories) {
            if (category.getAmbientDialogs() == null) continue;
            dialogs = (String[])ArrayUtils.addAll((Object[])dialogs, (Object[])category.getAmbientDialogs());
        }
        return dialogs.length > 0 ? dialogs : null;
    }

    @Nullable
    public static String[] getAmbientDialogsByNpcName(String npcName) {
        DialogNpc v = NAME_MAP.get(npcName.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.getAmbientDialogs();
    }

    @Nullable
    public String[] getDamageDialogs() {
        Object[] dialogs = new String[]{};
        for (DialogCategories category : this.dialogCategories) {
            if (category.getDamageDialogs() == null) continue;
            dialogs = (String[])ArrayUtils.addAll((Object[])dialogs, (Object[])category.getDamageDialogs());
        }
        return dialogs.length > 0 ? dialogs : null;
    }

    @Nullable
    public static String[] getDamageDialogsByNpcName(String npcName) {
        DialogNpc v = NAME_MAP.get(npcName.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.getDamageDialogs();
    }

    @Nullable
    public String[] getDeathDialogs() {
        Object[] dialogs = new String[]{};
        for (DialogCategories category : this.dialogCategories) {
            if (category.getDeathDialogs() == null) continue;
            dialogs = (String[])ArrayUtils.addAll((Object[])dialogs, (Object[])category.getDeathDialogs());
        }
        return dialogs.length > 0 ? dialogs : null;
    }

    @Nullable
    public static String[] getDeathDialogsByNpcName(String npcName) {
        DialogNpc v = NAME_MAP.get(npcName.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.getDeathDialogs();
    }

    @Nullable
    public String[] getWalkingDialogs() {
        Object[] dialogs = new String[]{};
        for (DialogCategories category : this.dialogCategories) {
            if (category.getWalkingDialogs() == null) continue;
            dialogs = (String[])ArrayUtils.addAll((Object[])dialogs, (Object[])category.getWalkingDialogs());
        }
        return dialogs.length > 0 ? dialogs : null;
    }

    @Nullable
    public static String[] getWalkingDialogsByNpcName(String npcName) {
        DialogNpc v = NAME_MAP.get(npcName.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.getWalkingDialogs();
    }

    public String getNpcName() {
        return this.npcName;
    }

    public int getNpcID() {
        return this.npcID;
    }

    public DialogCategories[] getDialogCategories() {
        return this.dialogCategories;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DialogNpc n : DialogNpc.values()) {
            String d = n.getNpcID() != -1 ? Integer.toString(n.getNpcID()) : n.getNpcName().toUpperCase();
            builder.put((Object)d, (Object)n);
        }
        NAME_MAP = builder.build();
    }
}

