/*
 * Decompiled with CFR 0.152.
 */
package com.NPCOverheadDialogue;

import com.NPCOverheadDialogue.ActorDialogState;
import com.NPCOverheadDialogue.NPCOverheadDialogueConfig;
import com.NPCOverheadDialogue.dialog.DialogNpc;
import com.google.common.base.MoreObjects;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.NPCManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Overhead Dialog")
public class NPCOverheadDialoguePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NPCOverheadDialoguePlugin.class);
    private static final int FAST_TICK_TIMEOUT = 2;
    private static final int SLOW_TICK_TIMEOUT = 5;
    private static final int MOVING_TICK_DELAY = 2;
    private static final int AMBIENT_TICK_TIMEOUT = 15;
    private static final Random RANDOM = new Random();
    @Inject
    private Client client;
    @Inject
    private NPCOverheadDialogueConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NPCManager npcManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final Map<Actor, ActorDialogState> dialogStateMap = new HashMap<Actor, ActorDialogState>();
    private Actor actor = null;
    private String lastNPCText = "";
    private int actorTextTick = 0;
    private String lastPlayerText = "";
    private int playerTextTick = 0;

    @Provides
    NPCOverheadDialogueConfig provideConfig(ConfigManager configManager) {
        return (NPCOverheadDialogueConfig)configManager.getConfig(NPCOverheadDialogueConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged c) {
        if (!c.getGameState().equals((Object)GameState.LOADING)) {
            return;
        }
        this.actor = null;
        this.lastNPCText = "";
        this.lastPlayerText = "";
        this.dialogStateMap.clear();
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getTarget() == null || event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        if (this.config.showDialogBoxText() && event.getSource() != this.actor && this.actor != null) {
            this.actor.setOverheadText(null);
        }
        this.lastNPCText = "";
        this.lastPlayerText = "";
        this.actor = event.getTarget();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (!(animationChanged.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)animationChanged.getActor();
        if (this.config.showDeathDialog() && npc.isDead() && npc.getName() != null) {
            DialogNpc dialogNpc = DialogNpc.getDialogNpcsByNpcID(npc.getId());
            if (dialogNpc == null) {
                dialogNpc = DialogNpc.getDialogNpcsByNpcName(Text.escapeJagex((String)((String)MoreObjects.firstNonNull((Object)npc.getName(), (Object)""))));
            }
            if (dialogNpc == null) {
                return;
            }
            ActorDialogState state = this.getOrCreateActorDialogState(npc);
            if (state == null) {
                return;
            }
            String[] dialogues = dialogNpc.getDeathDialogs();
            if (dialogues == null) {
                return;
            }
            this.setOverheadText(dialogues[RANDOM.nextInt(dialogues.length)], (Actor)npc, state);
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        String[] dialogues;
        if (event.getActor().getName() == null || !(event.getActor() instanceof NPC)) {
            return;
        }
        DialogNpc dialogNpc = DialogNpc.getDialogNpcsByNpcID(((NPC)event.getActor()).getId());
        if (dialogNpc == null) {
            dialogNpc = DialogNpc.getDialogNpcsByNpcName(Text.escapeJagex((String)((String)MoreObjects.firstNonNull((Object)event.getActor().getName(), (Object)""))));
        }
        if (dialogNpc == null) {
            return;
        }
        NPC npc = (NPC)event.getActor();
        ActorDialogState state = this.getOrCreateActorDialogState(npc);
        if (state == null) {
            return;
        }
        if (this.config.showDeathDialog() && npc.isDead() && (dialogues = dialogNpc.getDeathDialogs()) != null) {
            this.setOverheadText(dialogues[RANDOM.nextInt(dialogues.length)], (Actor)npc, state);
            state.setInCombat(true);
            return;
        }
        if (this.config.showDamageDialog() && event.getHitsplat().getAmount() > 0) {
            dialogues = dialogNpc.getDamageDialogs();
            if (dialogues == null) {
                return;
            }
            this.setOverheadText(dialogues[RANDOM.nextInt(dialogues.length)], (Actor)npc, state);
            state.setInCombat(true);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.actor != null) {
            if (this.config.showDialogBoxText()) {
                this.checkWidgetDialogs();
            }
            if (this.actorTextTick > 0 && this.client.getTickCount() - this.actorTextTick > 5) {
                this.actor.setOverheadText(null);
                this.actorTextTick = 0;
            }
        }
        if (this.client.getLocalPlayer() != null && this.playerTextTick > 0 && this.client.getTickCount() - this.playerTextTick > 5) {
            this.client.getLocalPlayer().setOverheadText(null);
            this.playerTextTick = 0;
        }
        this.npcTextInvoker();
        int currentTick = this.client.getTickCount();
        for (Map.Entry<Actor, ActorDialogState> entry : this.dialogStateMap.entrySet()) {
            int activeTicks;
            Actor actor = entry.getKey();
            ActorDialogState state = entry.getValue();
            int n = activeTicks = state.getDialogChangeTick() > 0 ? currentTick - state.getDialogChangeTick() : -1;
            if (state.getDialog() == null || state.isInCombat() && activeTicks > 2 || !state.isInCombat() && activeTicks > 5) {
                if (!Objects.equals(state.getDialog(), actor.getOverheadText())) {
                    state.setDialogChangeTick(this.client.getTickCount());
                }
                actor.setOverheadText(null);
                state.setDialog(null);
                state.setInCombat(false);
                continue;
            }
            this.setOverheadText(state.getDialog(), actor, state);
        }
    }

    private void npcTextInvoker() {
        for (NPC npc : this.client.getNpcs()) {
            ActorDialogState state;
            DialogNpc dialogNpc = DialogNpc.getDialogNpcsByNpcID(npc.getId());
            if (dialogNpc == null) {
                dialogNpc = DialogNpc.getDialogNpcsByNpcName(Text.escapeJagex((String)((String)MoreObjects.firstNonNull((Object)npc.getName(), (Object)""))));
            }
            if (dialogNpc == null || (state = this.getOrCreateActorDialogState(npc)) == null) continue;
            if (this.config.showWalkingDialog()) {
                this.checkWalkingDialog(npc, state);
            }
            if (!this.config.showAmbientDialog()) continue;
            this.checkAmbientDialog(npc, state);
        }
    }

    private void checkWalkingDialog(NPC npc, ActorDialogState state) {
        DialogNpc dialogNpc = DialogNpc.getDialogNpcsByNpcID(npc.getId());
        if (dialogNpc == null) {
            dialogNpc = DialogNpc.getDialogNpcsByNpcName(Text.escapeJagex((String)((String)MoreObjects.firstNonNull((Object)npc.getName(), (Object)""))));
        }
        if (dialogNpc == null) {
            return;
        }
        if (this.hasNpcMoved(npc)) {
            String[] dialogues = dialogNpc.getWalkingDialogs();
            if (dialogues == null) {
                return;
            }
            String dialogue = dialogues[RANDOM.nextInt(dialogues.length)];
            if (state.getTicksWithoutMoving() > 2) {
                this.setOverheadText(dialogue, (Actor)npc, state);
                state.setTicksWithoutMoving(0);
                log.info("set " + npc + " overhead text");
            }
        } else {
            state.setTicksWithoutMoving(state.getTicksWithoutMoving() + 1);
        }
    }

    private void checkAmbientDialog(NPC npc, ActorDialogState state) {
        DialogNpc dialogNpc = DialogNpc.getDialogNpcsByNpcID(npc.getId());
        if (dialogNpc == null) {
            dialogNpc = DialogNpc.getDialogNpcsByNpcName(Text.escapeJagex((String)((String)MoreObjects.firstNonNull((Object)npc.getName(), (Object)""))));
        }
        if (dialogNpc == null) {
            return;
        }
        log.info("NPC being checked is: " + dialogNpc.getNpcName() + " with an npcID of: " + dialogNpc.getNpcID());
        String[] dialogues = dialogNpc.getAmbientDialogs();
        if (dialogues == null) {
            return;
        }
        if (this.client.getTickCount() - state.getDialogChangeTick() >= 15 && RANDOM.nextInt(100) + 1 <= 1) {
            String dialogue = dialogues[RANDOM.nextInt(dialogues.length)];
            this.setOverheadText(dialogue, (Actor)npc, state);
            log.info(npc.getName() + " said: " + dialogue);
        }
    }

    private void checkWidgetDialogs() {
        ChatMessageBuilder message;
        String npcDialogText;
        Widget playerTextWidget = this.client.getWidget(WidgetInfo.DIALOG_PLAYER_TEXT);
        String playerDialogText = playerTextWidget != null ? playerTextWidget.getText() : null;
        Widget npcTextWidget = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        String string = npcDialogText = npcTextWidget != null ? npcTextWidget.getText() : null;
        if (npcDialogText != null && !this.lastNPCText.equals(npcDialogText)) {
            this.lastNPCText = npcDialogText;
            this.actor.setOverheadText(npcDialogText);
            if (this.config.enableChatDialog()) {
                message = new ChatMessageBuilder().append(Color.RED, this.actor.getName()).append(": ").append(Color.BLUE, npcDialogText);
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build()).build());
            }
            this.actorTextTick = this.client.getTickCount();
        }
        if (playerDialogText != null && !this.lastPlayerText.equals(playerDialogText)) {
            this.lastPlayerText = playerDialogText;
            if (this.client.getLocalPlayer() != null) {
                this.client.getLocalPlayer().setOverheadText(playerDialogText);
                if (this.config.enableChatDialog()) {
                    message = new ChatMessageBuilder().append(Color.RED, this.client.getLocalPlayer().getName()).append(": ").append(Color.BLUE, playerDialogText);
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build()).build());
                }
                this.playerTextTick = this.client.getTickCount();
            }
        }
    }

    private boolean hasNpcMoved(NPC npc) {
        ActorDialogState state = this.getOrCreateActorDialogState(npc);
        if (state == null) {
            return false;
        }
        WorldPoint npcPos = npc.getWorldLocation();
        WorldPoint lastNpcPos = new WorldPoint(state.getLastXCoordinate(), state.getLastYCoordinate(), -1);
        state.setLastXCoordinate(npc.getWorldLocation().getX());
        state.setLastYCoordinate(npc.getWorldLocation().getY());
        return npcPos.distanceTo2D(lastNpcPos) > 0;
    }

    @Nullable
    private ActorDialogState getOrCreateActorDialogState(NPC npc) {
        if (npc.getName() == null || !DialogNpc.isDialogNpc(Text.escapeJagex((String)npc.getName()))) {
            return null;
        }
        ActorDialogState result = this.dialogStateMap.get(npc);
        if (result == null) {
            result = new ActorDialogState((Actor)npc, Text.escapeJagex((String)npc.getName()), npc.getOverheadText(), npc.getOverheadText() == null ? 0 : this.client.getTickCount(), npc.getWorldLocation().getX(), npc.getWorldLocation().getY(), 2, false);
            this.dialogStateMap.put((Actor)npc, result);
        }
        return result;
    }

    private void setOverheadText(String dialogue, Actor actor, ActorDialogState state) {
        if (state.getDialogChangeTick() <= 0 || !Objects.equals(state.getDialog(), dialogue)) {
            state.setDialogChangeTick(this.client.getTickCount());
        }
        state.setDialog(dialogue);
        actor.setOverheadText(dialogue);
        if (this.config.enableChatDialog()) {
            ChatMessageBuilder message = new ChatMessageBuilder().append(Color.RED, actor.getName()).append(": ").append(Color.BLUE, dialogue);
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build()).build());
        }
    }
}

