/*
 * Decompiled with CFR 0.152.
 */
package com.owmchat;

import com.google.inject.Provides;
import com.owmchat.OWMChatConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.NPCManager;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Old Wise Man Chat")
public class OWMChatPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OWMChatPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OWMChatConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private NPCManager npcManager;
    private Actor actor = null;
    private String lastNPCText = "";
    private List<NPC> npcWhitelist = new ArrayList<NPC>();
    private List<String> whitelist = new ArrayList<String>();
    private final Map<NPC, HighlightedNpc> whitelistedNpc = new HashMap<NPC, HighlightedNpc>();
    private final Function<NPC, HighlightedNpc> isHighlighted = this.whitelistedNpc::get;
    private NpcOverlayService npcOverlayService;

    protected void startUp() throws Exception {
        log.info("[OWM-Chat] Plugin Initialized Successfully");
        this.sendChatMessage("[OWM-Chat] Plugin Initialized Successfully");
        this.sendChatMessage("[OWM-Chat] New Menu Entry: ");
        this.getWhitelist();
        this.rebuild();
    }

    private void addToWhitelist(String npcName) {
        this.whitelist = this.getWhitelist();
        if (!this.getWhitelist().contains(npcName)) {
            this.getWhitelist().add(npcName);
        }
    }

    private ChatMessageType getMenuOption() {
        Object menuEntry = null;
        return menuEntry.getType();
    }

    protected void shutDown() throws Exception {
        log.info("Looks like that's enough, back to bed bud.");
        this.sendChatMessage("[OWM-Chat] Looks like that's enough, back to bed bud.");
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        String bot = event.getActor().getName();
        String message = event.getOverheadText();
        if (this.whitelistMatchesNPCName(bot)) {
            this.sendChatMessage("[OWM-Notification] " + bot + ": " + message);
        }
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    @Provides
    OWMChatConfig provideConfig(ConfigManager configManager) {
        return (OWMChatConfig)configManager.getConfig(OWMChatConfig.class);
    }

    List<String> getWhitelist() {
        String configNpcs = this.config.getNpcWhitelist();
        if (configNpcs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNpcs);
    }

    private boolean whitelistMatchesNPCName(String npcName) {
        this.whitelist = this.getWhitelist();
        for (String highlight : this.whitelist) {
            if (!WildcardMatcher.matches((String)highlight, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    void rebuild() {
        this.whitelist = this.getWhitelist();
        this.whitelistedNpc.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName != null) continue;
        }
        this.npcOverlayService.rebuild();
    }

    Map<NPC, HighlightedNpc> getWhitelistedNpc() {
        return this.whitelistedNpc;
    }
}

