/*
 * Decompiled with CFR 0.152.
 */
package com.visualsounds;

import com.google.inject.Provides;
import com.visualsounds.GameSound;
import com.visualsounds.GameSoundList;
import com.visualsounds.SoundNames;
import com.visualsounds.VisualSoundsConfig;
import com.visualsounds.VisualSoundsOverlay;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Visual Sounds")
public class VisualSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VisualSoundsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private VisualSoundsConfig config;
    public GameSoundList gameSoundList = new GameSoundList();
    private SoundNames soundNames;
    @Inject
    private VisualSoundsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    private static final String OLD_CONFIG_GROUP = "example";
    private static final String CONFIG_GROUP = "visualsounds";
    private HashMap<Integer, Color> soundColors = new HashMap();
    private Set<Integer> ignoredSounds = new HashSet<Integer>();
    private boolean displaySoundEffects = true;
    private boolean displayAreaEffects = false;
    private boolean showOnlyTagged = false;
    private int regionId = -1;

    protected void startUp() throws Exception {
        log.info("Visual sounds started!");
        this.migrateOldConfigItems();
        this.overlayManager.add((Overlay)this.overlay);
        this.soundNames = new SoundNames();
        this.reload();
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChangedEvent) {
        this.reload();
    }

    protected void shutDown() throws Exception {
        log.info("Visual sounds stopped!");
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private <T> void migrateOldConfigItem(String key, Class<T> clazz) {
        Object old = this.configManager.getConfiguration(OLD_CONFIG_GROUP, key, clazz);
        if (old != null) {
            log.debug("Importing config item {}: {}", (Object)key, old);
            this.configManager.setConfiguration(CONFIG_GROUP, key, old);
            this.configManager.unsetConfiguration(OLD_CONFIG_GROUP, key);
        }
    }

    private void migrateOldConfigItems() {
        this.migrateOldConfigItem("displaySoundEffects", Boolean.TYPE);
        this.migrateOldConfigItem("displayAreaSounds", Boolean.TYPE);
        this.migrateOldConfigItem("soundCountLimit", Integer.TYPE);
        this.migrateOldConfigItem("category1SoundColor", Color.class);
        this.migrateOldConfigItem("taggedSoundsCat1", String.class);
        this.migrateOldConfigItem("category2SoundColor", Color.class);
        this.migrateOldConfigItem("taggedSoundsCat2", String.class);
        this.migrateOldConfigItem("category3SoundColor", Color.class);
        this.migrateOldConfigItem("taggedSoundsCat3", String.class);
        this.migrateOldConfigItem("ignoredSounds", String.class);
        this.migrateOldConfigItem("showOnlyTagged", Boolean.TYPE);
    }

    private void reload() {
        this.gameSoundList.setMaxLength(this.config.soundCountLimit());
        this.gameSoundList.add(new GameSound());
        this.ignoredSounds = VisualSoundsPlugin.getNumbersFromConfig(this.config.ignoredSounds());
        this.soundColors = new HashMap();
        this.addColors(this.config.taggedSoundsCat1(), this.config.category1SoundColor());
        this.addColors(this.config.taggedSoundsCat2(), this.config.category2SoundColor());
        this.addColors(this.config.taggedSoundsCat3(), this.config.category3SoundColor());
        this.displaySoundEffects = this.config.displaySoundEffects();
        this.displayAreaEffects = this.config.displayAreaSounds();
        this.showOnlyTagged = this.config.showOnlyTagged();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        if (!this.displaySoundEffects) {
            return;
        }
        this.handleSoundEffect(soundEffectPlayed.getSoundId());
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        if (!this.displayAreaEffects) {
            return;
        }
        this.handleSoundEffect(areaSoundEffectPlayed.getSoundId());
    }

    private void handleSoundEffect(int soundId) {
        String soundName;
        if (this.ignoredSounds.contains(soundId) || this.ignoreBoss()) {
            return;
        }
        if (this.showOnlyTagged && !this.soundColors.containsKey(soundId)) {
            return;
        }
        Color soundColor = this.soundColors.getOrDefault(soundId, Color.white);
        GameSound gameSound = new GameSound(soundId, soundColor);
        if (this.config.showSoundNames() && (soundName = this.soundNames.GetSoundName(soundId)) != null) {
            gameSound.label = String.format("%s (%d)", soundName, gameSound.soundId);
        }
        this.gameSoundList.add(gameSound);
    }

    private boolean ignoreBoss() {
        if (this.regionId == 5536) {
            return true;
        }
        if (this.regionId == 4405 || this.regionId == 8291 || this.regionId == 10595 || this.regionId == 12132) {
            return true;
        }
        if (this.regionId == 9023) {
            return true;
        }
        if (this.regionId == 9043 || this.regionId == 9551) {
            return true;
        }
        return this.client.getVarbitValue(5432) > 0 || this.client.getVarbitValue(14380) > 0 || this.client.getVarbitValue(6440) > 0;
    }

    @Provides
    VisualSoundsConfig provideConfig(ConfigManager configManager) {
        return (VisualSoundsConfig)configManager.getConfig(VisualSoundsConfig.class);
    }

    private void addColors(String source, Color colorToAdd) {
        Set<Integer> categorySounds = VisualSoundsPlugin.getNumbersFromConfig(source);
        for (Integer categorySound : categorySounds) {
            this.soundColors.computeIfAbsent(categorySound, o -> colorToAdd);
        }
    }

    private static Set<Integer> getNumbersFromConfig(String source) {
        return Arrays.stream(source.split(",")).map(String::trim).filter(NumberUtils::isParsable).map(Integer::parseInt).collect(Collectors.toSet());
    }
}

