/*
 * Decompiled with CFR 0.152.
 */
package com.visualsounds;

import com.visualsounds.GameSound;
import com.visualsounds.VisualSoundsPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class VisualSoundsOverlay
extends OverlayPanel {
    private final VisualSoundsPlugin plugin;

    @Inject
    public VisualSoundsOverlay(VisualSoundsPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPosition(OverlayPosition.DETACHED);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPreferredSize(new Dimension(25, 200));
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics2D) {
        List renderableEntities = this.panelComponent.getChildren();
        renderableEntities.clear();
        List<GameSound> gameSoundList = this.plugin.gameSoundList.getGameSoundList();
        for (GameSound gs : gameSoundList) {
            renderableEntities.add(LineComponent.builder().leftColor(gs.color).left(gs.label).build());
        }
        return super.render(graphics2D);
    }
}

