/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter.ui.panels;

import com.wintertodt.scouter.WintertodtBossData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;

public class WintertodtScouterSinglePanel
extends JPanel {
    private final JLabel time;
    private final WintertodtBossData bossData;
    private Color lastBackground;

    public WintertodtScouterSinglePanel(final WintertodtBossData bossData, final Consumer<Integer> onSelect) {
        this.bossData = bossData;
        this.setLayout((LayoutManager)new DynamicGridLayout(2, 1, 0, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        JLabel world = new JLabel("World " + bossData.getWorld());
        JLabel nameLabel = new JLabel("<html>" + bossData.getHealth() + "</html>");
        nameLabel.setHorizontalAlignment(2);
        nameLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        topPanel.add((Component)world, "West");
        topPanel.add((Component)nameLabel, "Center");
        this.time = new JLabel();
        this.updateLabels();
        this.add(topPanel);
        this.add(this.time);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && onSelect != null) {
                    onSelect.accept(bossData.getWorld());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WintertodtScouterSinglePanel.this.setBackground(WintertodtScouterSinglePanel.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WintertodtScouterSinglePanel.this.setBackground(WintertodtScouterSinglePanel.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WintertodtScouterSinglePanel.this.lastBackground = WintertodtScouterSinglePanel.this.getBackground();
                WintertodtScouterSinglePanel.this.setBackground(WintertodtScouterSinglePanel.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WintertodtScouterSinglePanel.this.setBackground(WintertodtScouterSinglePanel.this.lastBackground);
            }
        });
    }

    private void updateTime() {
        this.time.setText("" + this.bossData.getTime());
    }

    public void updateLabels() {
        this.updateTime();
        this.repaint();
        this.revalidate();
    }

    public WintertodtBossData getBossData() {
        return this.bossData;
    }
}

