/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter.ui.panels;

import com.wintertodt.scouter.WintertodtBossData;
import com.wintertodt.scouter.WintertodtScouterPlugin;
import com.wintertodt.scouter.ui.WintertodtScouterPluginPanelBase;
import com.wintertodt.scouter.ui.panels.FixedWidthPanel;
import com.wintertodt.scouter.ui.panels.WintertodtScouterSinglePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class WintertodtScouterPluginPanel
extends WintertodtScouterPluginPanelBase {
    FixedWidthPanel bossListPanel = new FixedWidthPanel();
    ArrayList<WintertodtScouterSinglePanel> bossList = new ArrayList();
    private final GridBagConstraints c = new GridBagConstraints();

    public WintertodtScouterPluginPanel(WintertodtScouterPlugin plugin) {
        super(plugin, false);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel topContainer = new JPanel();
        topContainer.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Wintertodt Scouter");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        topContainer.add((Component)titlePanel, "North");
        this.add(topContainer, "North");
        this.bossListPanel.setLayout(new GridBagLayout());
        this.bossListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.c.insets = new Insets(0, 2, 2, 2);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 0;
        this.c.anchor = 19;
        JScrollPane scrollPane = new JScrollPane(this.bossListPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(new EmptyBorder(1, 0, 0, 0));
        scrollPane.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add(scrollPane, "Center");
    }

    public void addBossData(JPanel wintertodtScouterPanel, WintertodtBossData data) {
        WintertodtScouterSinglePanel bossDataPanel = new WintertodtScouterSinglePanel(data, this.plugin::hopTo);
        wintertodtScouterPanel.add((Component)bossDataPanel, this.c);
        ++this.c.gridy;
        this.bossList.add(bossDataPanel);
    }

    @Override
    public void populate(List<WintertodtBossData> globalBossData) {
        this.c.gridy = 0;
        this.c.weighty = 0.0;
        for (WintertodtScouterSinglePanel bossSinglePanel : this.bossList) {
            this.bossListPanel.remove(bossSinglePanel);
        }
        this.bossList.clear();
        WintertodtBossData lastData = null;
        for (WintertodtBossData bossData : globalBossData) {
            if (lastData != null) {
                this.addBossData(this.bossListPanel, lastData);
            }
            lastData = bossData;
        }
        this.c.weighty = 1.0;
        if (lastData != null) {
            this.addBossData(this.bossListPanel, lastData);
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    public void updateList() {
        for (WintertodtScouterSinglePanel bossSinglePanel : this.bossList) {
            bossSinglePanel.updateLabels();
        }
    }
}

