/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter.ui.condensed;

import com.wintertodt.scouter.WintertodtScouterPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.worlds.World;

public class WintertodtScouterTableRow
extends JPanel {
    private static final int WORLD_COLUMN_WIDTH = 55;
    private static final int TIME_COLUMN_WIDTH = 55;
    private static final Color CURRENT_WORLD = new Color(66, 227, 17);
    final BufferedImage bar5 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/5.png");
    final BufferedImage bar4 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/4.png");
    final BufferedImage bar3 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/3.png");
    final BufferedImage bar2 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/2.png");
    final BufferedImage bar1 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/1.png");
    final BufferedImage bar0 = ImageUtil.loadImageResource(WintertodtScouterPlugin.class, (String)"/0.png");
    private JLabel worldField;
    private JLabel healthField;
    private JLabel timerField;
    private JProgressBar healthBar;
    private JLabel latency;
    private final World world;
    private int bossworld;
    private int health;
    private int timer;
    private long time;
    private Color lastBackground;
    private final MouseAdapter labelMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            WintertodtScouterTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            WintertodtScouterTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            WintertodtScouterTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            WintertodtScouterTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            WintertodtScouterTableRow.this.dispatchEvent(mouseEvent);
        }
    };

    WintertodtScouterTableRow(final World world, int bossworld, boolean current, int health, int timer, long time, final Consumer<World> onSelect) {
        this.world = world;
        this.bossworld = bossworld;
        this.health = health;
        this.timer = timer;
        this.time = time;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && onSelect != null) {
                    onSelect.accept(world);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WintertodtScouterTableRow.this.setBackground(WintertodtScouterTableRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WintertodtScouterTableRow.this.setBackground(WintertodtScouterTableRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WintertodtScouterTableRow.this.lastBackground = WintertodtScouterTableRow.this.getBackground();
                WintertodtScouterTableRow.this.setBackground(WintertodtScouterTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WintertodtScouterTableRow.this.setBackground(WintertodtScouterTableRow.this.lastBackground);
            }
        });
        JPanel status = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        status.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel worldField = this.buildWorldField();
        worldField.setPreferredSize(new Dimension(55, 20));
        worldField.setOpaque(false);
        JPanel healthField = this.buildHealthField();
        healthField.setPreferredSize(new Dimension(55, 20));
        healthField.setOpaque(false);
        JPanel timerField = this.buildTimerField();
        timerField.setPreferredSize(new Dimension(55, 20));
        timerField.setOpaque(false);
        this.updateStatus(current);
        status.add((Component)worldField, "West");
        status.add((Component)healthField, "Center");
        status.add((Component)timerField, "East");
        this.add((Component)status, "Center");
    }

    void updateStatus(boolean current) {
        this.healthBar.setStringPainted(true);
        this.healthBar.setValue(this.getHealth());
        this.healthBar.setString(this.getHealth() + "%");
        this.healthBar.setForeground(Color.green);
        this.timerField.setText("" + this.getTimer());
        if (this.getHealth() <= 60) {
            this.healthBar.setForeground(Color.orange);
        }
        if (this.getHealth() <= 50) {
            this.healthBar.setForeground(Color.red);
        }
        this.recolour(current);
    }

    void updateInfo(int health, int world, int timer, boolean current) {
        this.timer = timer;
        this.health = health;
        this.bossworld = world;
        this.updateStatus(current);
    }

    private static StringBool timeString(Instant time) {
        long s = Duration.between(Instant.now(), time).getSeconds();
        boolean negative = false;
        if (s < 0L) {
            s *= -1L;
            negative = true;
        }
        long mins = s / 60L;
        long secs = s % 60L;
        String str = negative ? (mins > 9L ? String.format("-%dm", mins) : String.format("-%1d:%02d", mins, secs)) : (mins > 99L ? String.format("%dm", mins) : String.format("%1d:%02d", mins, secs));
        return new StringBool(str, negative);
    }

    public void recolour(boolean current) {
        if (current) {
            this.worldField.setForeground(CURRENT_WORLD);
            return;
        }
    }

    private JPanel buildWorldField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.worldField = new JLabel("" + this.world.getId());
        column.add((Component)this.worldField, "West");
        long now = Instant.now().getEpochSecond();
        this.latency = new JLabel(new ImageIcon(this.bar0));
        long difference = now - this.time;
        this.latency.setIcon(new ImageIcon(this.bar5));
        if (difference > 5L) {
            this.latency.setIcon(new ImageIcon(this.bar5));
        }
        if (difference > 10L) {
            this.latency.setIcon(new ImageIcon(this.bar4));
        }
        if (difference > 15L) {
            this.latency.setIcon(new ImageIcon(this.bar3));
        }
        if (difference > 20L) {
            this.latency.setIcon(new ImageIcon(this.bar2));
        }
        if (difference > 25L) {
            this.latency.setIcon(new ImageIcon(this.bar1));
        }
        if (difference > 30L) {
            this.latency.setIcon(new ImageIcon(this.bar0));
        }
        column.add((Component)this.latency, "East");
        this.latency.setBorder(new EmptyBorder(0, 2, 0, 0));
        return column;
    }

    private JPanel buildHealthField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.healthBar = new JProgressBar();
        this.healthBar.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.healthBar, "Center");
        return column;
    }

    private JPanel buildTimerField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.timerField = new JLabel();
        this.timerField.setFont(FontManager.getRunescapeSmallFont());
        this.timerField.setHorizontalAlignment(0);
        column.add((Component)this.timerField, "Center");
        return column;
    }

    public World getWorld() {
        return this.world;
    }

    public int getBossworld() {
        return this.bossworld;
    }

    public int getHealth() {
        return this.health;
    }

    public int getTimer() {
        return this.timer;
    }

    public long getTime() {
        return this.time;
    }

    private static final class StringBool {
        private final String string;
        private final boolean boolValue;

        public String getString() {
            return this.string;
        }

        public boolean isBoolValue() {
            return this.boolValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringBool)) {
                return false;
            }
            StringBool other = (StringBool)o;
            if (this.isBoolValue() != other.isBoolValue()) {
                return false;
            }
            String this$string = this.getString();
            String other$string = other.getString();
            return !(this$string == null ? other$string != null : !this$string.equals(other$string));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBoolValue() ? 79 : 97);
            String $string = this.getString();
            result = result * 59 + ($string == null ? 43 : $string.hashCode());
            return result;
        }

        public String toString() {
            return "WintertodtScouterTableRow.StringBool(string=" + this.getString() + ", boolValue=" + this.isBoolValue() + ")";
        }

        public StringBool(String string, boolean boolValue) {
            this.string = string;
            this.boolValue = boolValue;
        }
    }
}

