/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter.ui.condensed;

import com.wintertodt.scouter.WintertodtBossData;
import com.wintertodt.scouter.WintertodtScouterPlugin;
import com.wintertodt.scouter.ui.WintertodtScouterPluginPanelBase;
import com.wintertodt.scouter.ui.condensed.WintertodtScouterOrder;
import com.wintertodt.scouter.ui.condensed.WintertodtScouterPanelHeader;
import com.wintertodt.scouter.ui.condensed.WintertodtScouterTableRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.http.api.worlds.World;

public class WintertodtScouterCondensedPluginPanel
extends WintertodtScouterPluginPanelBase {
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private static final int WORLD_COLUMN_WIDTH = 55;
    private static final int TIME_COLUMN_WIDTH = 55;
    private final JPanel listContainer = new JPanel();
    private WintertodtScouterPanelHeader worldHeader;
    private WintertodtScouterPanelHeader healthHeader;
    private WintertodtScouterPanelHeader timerHeader;
    private WintertodtScouterOrder orderIndex = WintertodtScouterOrder.HEALTH;
    private boolean ascendingOrder = true;
    private final ArrayList<WintertodtScouterTableRow> rows = new ArrayList();

    public WintertodtScouterCondensedPluginPanel(WintertodtScouterPlugin plugin) {
        super(plugin);
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel title = this.title();
        JPanel tip = this.tip();
        JPanel headerContainer = this.buildHeader();
        JPanel p = new JPanel();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(title);
        this.add(headerContainer);
        this.add(this.listContainer);
        this.add(tip);
    }

    private JPanel title() {
        JLabel title = new JLabel("Wintertodt Scouter");
        title.setFont(FontManager.getRunescapeBoldFont());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setLayout(new GridBagLayout());
        panel.add(title);
        return panel;
    }

    private JPanel tip() {
        JPanel layout = new JPanel(new BorderLayout());
        JLabel tip = new JLabel("You can double click to hop worlds!");
        tip.setFont(FontManager.getRunescapeSmallFont());
        layout.add(tip);
        layout.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Tip"));
        return layout;
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel status = new JPanel(new BorderLayout());
        this.healthHeader = new WintertodtScouterPanelHeader("Health", this.orderIndex == WintertodtScouterOrder.HEALTH, this.ascendingOrder);
        this.healthHeader.setPreferredSize(new Dimension(55, 50));
        this.healthHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WintertodtScouterCondensedPluginPanel.this.ascendingOrder = WintertodtScouterCondensedPluginPanel.this.orderIndex != WintertodtScouterOrder.HEALTH || !WintertodtScouterCondensedPluginPanel.this.ascendingOrder;
                WintertodtScouterCondensedPluginPanel.this.orderBy(WintertodtScouterOrder.HEALTH);
            }
        });
        this.worldHeader = new WintertodtScouterPanelHeader("World", this.orderIndex == WintertodtScouterOrder.WORLD, this.ascendingOrder);
        this.worldHeader.setPreferredSize(new Dimension(55, 50));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WintertodtScouterCondensedPluginPanel.this.ascendingOrder = WintertodtScouterCondensedPluginPanel.this.orderIndex != WintertodtScouterOrder.WORLD || !WintertodtScouterCondensedPluginPanel.this.ascendingOrder;
                WintertodtScouterCondensedPluginPanel.this.orderBy(WintertodtScouterOrder.WORLD);
            }
        });
        this.timerHeader = new WintertodtScouterPanelHeader("Reset", this.orderIndex == WintertodtScouterOrder.TIMER, this.ascendingOrder);
        this.timerHeader.setPreferredSize(new Dimension(55, 50));
        this.timerHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WintertodtScouterCondensedPluginPanel.this.ascendingOrder = WintertodtScouterCondensedPluginPanel.this.orderIndex != WintertodtScouterOrder.TIMER || !WintertodtScouterCondensedPluginPanel.this.ascendingOrder;
                WintertodtScouterCondensedPluginPanel.this.orderBy(WintertodtScouterOrder.TIMER);
            }
        });
        status.add((Component)this.worldHeader, "West");
        status.add((Component)this.healthHeader, "Center");
        status.add((Component)this.timerHeader, "East");
        header.add((Component)status, "Center");
        return header;
    }

    private void orderBy(WintertodtScouterOrder order) {
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.healthHeader.highlight(false, this.ascendingOrder);
        this.timerHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case HEALTH: {
                this.healthHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case TIMER: {
                this.timerHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    @Override
    public void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case HEALTH: {
                    return this.getCompareValue((WintertodtScouterTableRow)r1, (WintertodtScouterTableRow)r2, WintertodtScouterTableRow::getHealth);
                }
                case WORLD: {
                    return this.getCompareValue((WintertodtScouterTableRow)r1, (WintertodtScouterTableRow)r2, WintertodtScouterTableRow::getBossworld);
                }
                case TIMER: {
                    return this.getCompareValue((WintertodtScouterTableRow)r1, (WintertodtScouterTableRow)r2, WintertodtScouterTableRow::getTimer);
                }
            }
            return 0;
        });
        this.listContainer.removeAll();
        int currentWorld = this.plugin.getCurrentWorld();
        int i = 0;
        for (WintertodtScouterTableRow row : this.rows) {
            row.updateStatus(row.getWorld().getId() == currentWorld);
            this.setColorOnRow(row, i++ % 2 == 0);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private int getCompareValue(WintertodtScouterTableRow row1, WintertodtScouterTableRow row2, Function<WintertodtScouterTableRow, Comparable> compareByFn) {
        Comparator<WintertodtScouterTableRow> c = this.ascendingOrder ? Comparator.comparing(compareByFn, Comparator.naturalOrder()) : Comparator.comparing(compareByFn, Comparator.reverseOrder());
        return c.thenComparing(WintertodtScouterTableRow::getHealth, Comparator.naturalOrder()).compare(row1, row2);
    }

    @Override
    public void populate(List<WintertodtBossData> globalBossData) {
        this.rows.clear();
        for (int i = 0; i < globalBossData.size(); ++i) {
            WintertodtBossData boss = globalBossData.get(i);
            this.rows.add(this.buildRow(globalBossData, i % 2 == 0, i));
        }
        this.updateList();
    }

    private WintertodtScouterTableRow buildRow(List<WintertodtBossData> bossData, boolean stripe, int index) {
        World world = this.plugin.getWorldService().getWorlds().findWorld(bossData.get(index).getWorld());
        boolean current = this.plugin.getCurrentWorld() == bossData.get(index).getWorld();
        WintertodtScouterTableRow row = new WintertodtScouterTableRow(world, bossData.get(index).getWorld(), current, bossData.get(index).getHealth(), bossData.get(index).getTimer(), bossData.get(index).getTime(), this.plugin::hopTo);
        this.setColorOnRow(row, stripe);
        return row;
    }

    private void setColorOnRow(WintertodtScouterTableRow row, boolean stripe) {
        Color c = stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR;
        row.setBackground(c);
    }
}

