/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter;

import com.google.inject.Provides;
import com.wintertodt.scouter.WintertodtBossData;
import com.wintertodt.scouter.WintertodtScouterConfig;
import com.wintertodt.scouter.WintertodtScouterNetwork;
import com.wintertodt.scouter.WintertodtScouterOverlayPanel;
import com.wintertodt.scouter.ui.WintertodtScouterPluginPanelBase;
import com.wintertodt.scouter.ui.condensed.WintertodtScouterCondensedPluginPanel;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wintertodt Scouter", description="Crowdsources the health of the Wintertodt Boss in themed worlds", tags={"firemaking", "wintertodt", "status", "health"})
public class WintertodtScouterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WintertodtScouterPlugin.class);
    public ArrayList<WintertodtBossData> localBossDataArrayList = new ArrayList();
    String apiVersion = "2";
    public ArrayList<WintertodtBossData> globalBossDataArrayList = new ArrayList();
    private WintertodtScouterCondensedPluginPanel panel;
    private static final int WINTERTODT_REGION = 6462;
    private final int SECONDS_BETWEEN_UPLINK = 1;
    private final int SECONDS_BETWEEN_DOWNLINK = 1;
    private final int SECONDS_BETWEEN_PANEL_REFRESH = 5;
    private boolean canRefresh;
    private final int SECONDS_BETWEEN_POLL_HEALTH = 1;
    public static final int WINTERTODT_HEALTH_PACKED_ID = 25952276;
    public static final int WINTERTODT_GAME_TIMER_ID = 25952276;
    static final String CONFIG_GROUP_KEY = "scouter";
    @Inject
    private ChatMessageManager chatMessageManager;
    String wintertodtGetUplink;
    String wintertodtGetDownlink;
    private boolean postError = false;
    private boolean getError = false;
    @Inject
    Client client;
    @Inject
    private WintertodtScouterNetwork manager;
    @Inject
    private WintertodtScouterConfig config;
    @Inject
    private WintertodtScouterOverlayPanel overlayPanel;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WorldService worldService;
    private WintertodtScouterPluginPanelBase wintertodtScouterPanel;
    private NavigationButton navButton = null;
    private final BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/wintertodt-scouter-icon.png");
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;

    protected void startUp() throws Exception {
        log.info("Wintertodt-Scouter started!");
        this.canRefresh = true;
        this.wintertodtGetUplink = this.config.wintertodtGetUplinkConfig();
        this.wintertodtGetDownlink = this.config.wintertodtGetDownlinkConfig();
        this.overlayManager.add((Overlay)this.overlayPanel);
        this.loadPluginPanel();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlayPanel);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP_KEY)) {
            return;
        }
        switch (event.getKey()) {
            case "get uplink": {
                this.wintertodtGetUplink = this.config.wintertodtGetUplinkConfig();
                break;
            }
            case "get downlink": {
                this.wintertodtGetDownlink = this.config.wintertodtGetDownlinkConfig();
                this.manager.makeGetRequest();
                break;
            }
            default: {
                this.updatePanelList();
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.handleHop();
        this.captureBossHealth();
    }

    private boolean isInWintertodtRegion() {
        if (this.client.getLocalPlayer() != null) {
            return this.client.getLocalPlayer().getWorldLocation().getRegionID() == 6462;
        }
        return false;
    }

    public void updatePanelList() {
        log.debug("Update panel list");
        SwingUtilities.invokeLater(() -> this.wintertodtScouterPanel.populate(this.globalBossDataArrayList.stream().filter(this::isAllowedWorld).collect(Collectors.toList())));
    }

    public void captureBossHealth() {
        if (this.client.getGameState() != GameState.HOPPING) {
            Widget wintertodtEnergyWidget = this.client.getWidget(25952276);
            if (this.isInWintertodtRegion() && wintertodtEnergyWidget != null) {
                Pattern regex = Pattern.compile("\\d+");
                Matcher bossEnergy = regex.matcher(wintertodtEnergyWidget.getText().toString());
                if (bossEnergy.find()) {
                    WintertodtBossData previous;
                    int energy = Integer.parseInt(bossEnergy.group(0));
                    int world = this.client.getWorld();
                    long unixTime = Instant.now().getEpochSecond();
                    if (energy == 0) {
                        this.captureResetTimer();
                        return;
                    }
                    WintertodtBossData current = new WintertodtBossData(energy, world, unixTime, false, -1);
                    if (this.localBossDataArrayList.size() > 1 && (previous = this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1)).getWorld() == current.getWorld() && previous.getHealth() == current.getHealth()) {
                        return;
                    }
                    this.localBossDataArrayList.add(current);
                }
                if (this.localBossDataArrayList.size() > 0) {
                    log.debug(this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1).getTime() + ": Health: " + this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1).getHealth());
                }
                this.updatePanelList();
            }
        }
    }

    public void captureResetTimer() {
        if (this.client.getGameState() != GameState.HOPPING) {
            Widget wintertodtResetWidget = this.client.getWidget(25952276);
            if (this.isInWintertodtRegion() && wintertodtResetWidget != null) {
                Pattern regex = Pattern.compile("\\d:\\d+");
                Matcher bossTimer = regex.matcher(wintertodtResetWidget.getText());
                if (bossTimer.find()) {
                    WintertodtBossData previous;
                    String time = bossTimer.group(0);
                    String minute = time.split(":")[0];
                    String second = time.split(":")[1];
                    int seconds = minute.equals("1") ? 60 + Integer.parseInt(second) : Integer.parseInt(second);
                    int timer = seconds;
                    int world = this.client.getWorld();
                    long unixTime = Instant.now().getEpochSecond();
                    WintertodtBossData current = new WintertodtBossData(-1, world, unixTime, false, timer);
                    if (this.localBossDataArrayList.size() > 1 && (previous = this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1)).getWorld() == current.getWorld() && previous.getTimer() == current.getTimer()) {
                        log.debug("- Skipped Data, it's the same.");
                        return;
                    }
                    this.localBossDataArrayList.add(current);
                }
                if (this.localBossDataArrayList.size() > 0) {
                    log.debug(this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1).getTime() + ": Timer: " + this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1).getTimer());
                }
                this.updatePanelList();
            }
        }
    }

    private void loadPluginPanel() {
        if (this.navButton != null) {
            this.clientToolbar.removeNavigation(this.navButton);
        }
        this.wintertodtScouterPanel = new WintertodtScouterCondensedPluginPanel(this);
        this.navButton = NavigationButton.builder().tooltip("Wintertodt Scouter").icon(this.icon).priority(7).panel((PluginPanel)this.wintertodtScouterPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Provides
    WintertodtScouterConfig provideConfig(ConfigManager configManager) {
        return (WintertodtScouterConfig)configManager.getConfig(WintertodtScouterConfig.class);
    }

    private boolean isAllowedWorld(WintertodtBossData bossData) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return false;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(bossData.getWorld());
        return world != null;
    }

    public int getCurrentWorld() {
        return this.client.getWorld();
    }

    public void hopTo(net.runelite.http.api.worlds.World world) {
        this.hopTo(world.getId());
    }

    public void hopTo(int worldId) {
        this.clientThread.invoke(() -> this.hop(worldId));
    }

    private void hop(int worldId) {
        assert (this.client.isClientThread());
        if (!this.config.isWorldHopperEnabled()) {
            return;
        }
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        this.quickHopTargetWorld = rsWorld;
    }

    private void handleHop() {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            this.localBossDataArrayList.clear();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.quickHopTargetWorld = null;
        this.displaySwitcherAttempts = 0;
        this.hitAPI();
    }

    public void hitAPI() {
        if (this.canRefresh && (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.HOPPING) && this.wintertodtScouterPanel.isOpen()) {
            this.canRefresh = true;
            this.manager.makeGetRequest();
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void submitToAPI() {
        if ((this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() != GameState.HOPPING) && this.isInWintertodtRegion() && this.localBossDataArrayList.size() > 0) {
            WintertodtBossData last = this.localBossDataArrayList.get(this.localBossDataArrayList.size() - 1);
            last.setTime(Instant.now().getEpochSecond());
            if (!last.isUploaded()) {
                this.manager.submitToAPI(this.processLocalData(this.localBossDataArrayList));
            }
        }
    }

    WintertodtBossData processLocalData(ArrayList<WintertodtBossData> localBossDataArrayList) {
        WintertodtBossData last = localBossDataArrayList.get(localBossDataArrayList.size() - 1);
        for (WintertodtBossData data : localBossDataArrayList) {
            if (data.isUploaded()) continue;
            data.setUploaded(true);
        }
        return last;
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void attemptGetRequest() {
        log.debug("Attempt get request");
        this.hitAPI();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ArrayList<WintertodtBossData> getGlobalBossDataArrayList() {
        return this.globalBossDataArrayList;
    }

    public void setGlobalBossDataArrayList(ArrayList<WintertodtBossData> globalBossDataArrayList) {
        this.globalBossDataArrayList = globalBossDataArrayList;
    }

    public String getWintertodtGetUplink() {
        return this.wintertodtGetUplink;
    }

    public String getWintertodtGetDownlink() {
        return this.wintertodtGetDownlink;
    }

    public boolean isPostError() {
        return this.postError;
    }

    public void setPostError(boolean postError) {
        this.postError = postError;
    }

    public boolean isGetError() {
        return this.getError;
    }

    public void setGetError(boolean getError) {
        this.getError = getError;
    }

    public WintertodtScouterConfig getConfig() {
        return this.config;
    }

    public WorldService getWorldService() {
        return this.worldService;
    }

    public static class WintertodtBossDataComparator
    implements Comparator<WintertodtBossData> {
        @Override
        public int compare(WintertodtBossData o1, WintertodtBossData o2) {
            return o1.convertToDate().compareTo(o2.convertToDate());
        }
    }
}

