/*
 * Decompiled with CFR 0.152.
 */
package com.wintertodt.scouter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.wintertodt.scouter.WintertodtBossData;
import com.wintertodt.scouter.WintertodtScouterPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WintertodtScouterNetwork {
    private static final Logger log = LoggerFactory.getLogger(WintertodtScouterNetwork.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private WintertodtScouterPlugin plugin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitToAPI(WintertodtBossData data) {
        ArrayList<Object> temp = new ArrayList<Object>();
        WintertodtScouterNetwork wintertodtScouterNetwork = this;
        synchronized (wintertodtScouterNetwork) {
            if (data == null) {
                return;
            }
            temp.add(data);
        }
        this.makePostRequest(temp);
    }

    private ArrayList<WintertodtBossData> parseData(JsonArray j) {
        ArrayList<WintertodtBossData> list = new ArrayList<WintertodtBossData>();
        for (JsonElement jsonElement : j) {
            JsonObject jObj = jsonElement.getAsJsonObject();
            try {
                WintertodtBossData globalBossData = new WintertodtBossData(jObj.get("a").getAsInt(), jObj.get("b").getAsInt(), jObj.get("c").getAsLong(), false, jObj.get("d").getAsInt());
                list.add(globalBossData);
            }
            catch (UnsupportedOperationException uos) {
                log.error("Boss Data Json Error: " + uos.getLocalizedMessage());
            }
        }
        return list;
    }

    protected void makePostRequest(List<Object> temp) {
        try {
            Request r = new Request.Builder().url(this.plugin.getWintertodtGetUplink()).addHeader("Authorization", "post").post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson(temp))).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error sending wintertodt boss data", (Throwable)e);
                    WintertodtScouterNetwork.this.plugin.setPostError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        log.debug("Successfully sent wintertodt boss data");
                        WintertodtScouterNetwork.this.plugin.setPostError(false);
                        response.close();
                    } else {
                        log.debug("Post request unsuccessful");
                        WintertodtScouterNetwork.this.plugin.setPostError(true);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
            this.plugin.setPostError(true);
        }
    }

    protected void makeGetRequest() {
        try {
            Request r = new Request.Builder().url(this.plugin.getWintertodtGetDownlink()).addHeader("Authorization", this.plugin.apiVersion).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error retrieving wintertodt boss data", (Throwable)e);
                    WintertodtScouterNetwork.this.plugin.setGetError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        try {
                            JsonArray j = (JsonArray)WintertodtScouterNetwork.this.gson.fromJson(response.body().string(), JsonArray.class);
                            try {
                                WintertodtScouterNetwork.this.plugin.setGlobalBossDataArrayList(WintertodtScouterNetwork.this.parseData(j));
                            }
                            catch (NullPointerException e) {
                                log.error("null data from downlink: " + e.getMessage());
                            }
                            log.debug(j.toString());
                            WintertodtScouterNetwork.this.plugin.setGetError(false);
                            WintertodtScouterNetwork.this.plugin.updatePanelList();
                            response.close();
                        }
                        catch (JsonSyntaxException | IOException e) {
                            WintertodtScouterNetwork.this.plugin.setGetError(true);
                            log.error(e.getMessage());
                            response.close();
                        }
                    } else {
                        log.error("Get request unsuccessful");
                        WintertodtScouterNetwork.this.plugin.setGetError(true);
                        response.close();
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }
}

