/*
 * Decompiled with CFR 0.152.
 */
package com.nylostats;

import com.google.inject.Provides;
import com.nylostats.NyloStatsConfig;
import com.nylostats.Nylospawns;
import com.nylostats.StallDisplays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Nylo Stats")
public class NyloStatsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NyloStatsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NyloStatsConfig config;
    private int currWave;
    private int stalls;
    private int ticksSinceLastWave;
    private int[] splits;
    private int[] preCapSplits;
    private int[] bossRotation;
    private boolean isHmt;
    private int currCap;
    private ArrayList<String> stallMessagesAll;
    private ArrayList<String> stallMessagesCollapsed;
    private static final Pattern NYLO_COMPLETE = Pattern.compile("Wave 'The Nylocas' \\(.*\\) complete!");
    private final int NYLOCAS_REGIONID = 13122;
    private static final HashMap<Integer, Integer> waveNaturalStalls = new HashMap();

    protected void startUp() throws Exception {
        this.currWave = 0;
        this.ticksSinceLastWave = 0;
        this.stalls = 0;
        this.currCap = 12;
        this.isHmt = false;
        this.stallMessagesAll = new ArrayList();
        this.stallMessagesCollapsed = new ArrayList();
        this.splits = new int[3];
        this.preCapSplits = new int[3];
        this.bossRotation = new int[3];
        this.bossRotation[0] = 1;
    }

    protected void shutDown() throws Exception {
        this.reset();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.inNyloRegion()) {
            return;
        }
        if (this.ticksSinceLastWave % 4 == 0 && this.currWave > 1 && this.currWave < 31 && this.ticksSinceLastWave >= waveNaturalStalls.get(this.currWave)) {
            if (this.isHmt && this.hmtWavesCheck() == 1) {
                return;
            }
            if (this.currWave > 19) {
                this.currCap = 24;
            }
            int aliveNylos = 0;
            for (NPC npc : this.client.getNpcs()) {
                if (Objects.equals(npc.getName(), "Nylocas Ischyros") || Objects.equals(npc.getName(), "Nylocas Toxobolos") || Objects.equals(npc.getName(), "Nylocas Hagios")) {
                    ++aliveNylos;
                }
                if (!Objects.equals(npc.getName(), "Nylocas Prinkipas")) continue;
                aliveNylos += 3;
            }
            if (aliveNylos >= this.currCap) {
                String stallMsg = "Stalled wave: <col=EF1020>" + this.currWave + "/31</col>";
                if (this.config.showStalls() == StallDisplays.ALL_ALIVE || this.config.showStalls() == StallDisplays.ALL_ALIVE_TOTAL) {
                    stallMsg = stallMsg + " - Nylos alive: <col=EF1020>" + aliveNylos + "/" + this.currCap + "</col>";
                }
                if (this.config.showStalls() == StallDisplays.ALL_ALIVE_TOTAL) {
                    stallMsg = stallMsg + " - Total Stalls: <col=EF1020>" + (this.stallMessagesAll.size() + 1) + "</col>";
                }
                this.stallMessagesAll.add(stallMsg);
            }
        }
        ++this.ticksSinceLastWave;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (Objects.equals(npc.getName(), "Nylocas Ischyros") || Objects.equals(npc.getName(), "Nylocas Toxobolos") || Objects.equals(npc.getName(), "Nylocas Hagios")) {
            WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)npc.getLocalLocation());
            Point point = new Point(location.getRegionX(), location.getRegionY());
            Nylospawns nylospawn = Nylospawns.getLookup().get(point);
            if (nylospawn == null) {
                if (npc.getId() == 8342 || npc.getId() == 10774 || npc.getId() == 10791) {
                    this.splits[0] = this.splits[0] + 1;
                } else if (npc.getId() == 8343 || npc.getId() == 10775 || npc.getId() == 10792) {
                    this.splits[1] = this.splits[1] + 1;
                } else if (npc.getId() == 8344 || npc.getId() == 10776 || npc.getId() == 10793) {
                    this.splits[2] = this.splits[2] + 1;
                }
                if (npc.getId() == 10791 || npc.getId() == 10792 || npc.getId() == 17093) {
                    this.isHmt = true;
                }
            } else if (this.ticksSinceLastWave > 3) {
                if (this.currWave > 1 && this.ticksSinceLastWave - waveNaturalStalls.get(this.currWave) > 0) {
                    int stallAmount = (this.ticksSinceLastWave - waveNaturalStalls.get(this.currWave)) / 4;
                    if (this.isHmt && this.currWave == 10) {
                        stallAmount -= 2;
                    } else if (this.isHmt && this.currWave == 30) {
                        stallAmount -= 3;
                    }
                    this.stalls += stallAmount;
                    if (stallAmount == 1) {
                        this.stallMessagesCollapsed.add("Stalled wave: <col=EF1020>" + this.currWave + "/31</col> - <col=EF1020>" + stallAmount + "</col> time");
                    } else if (stallAmount > 1) {
                        this.stallMessagesCollapsed.add("Stalled wave: <col=EF1020>" + this.currWave + "/31</col> - <col=EF1020>" + stallAmount + "</col> times");
                    }
                }
                ++this.currWave;
                if (this.currWave == 20) {
                    this.preCapSplits = (int[])this.splits.clone();
                }
                this.ticksSinceLastWave = 0;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.inNyloRegion() || event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String msg = Text.removeTags((String)event.getMessage());
        if (NYLO_COMPLETE.matcher(msg).find()) {
            if (this.currWave != 31) {
                this.reset();
                return;
            }
            if (this.config.showStalls() != StallDisplays.OFF) {
                this.printStalls();
            }
            if (this.config.showTotalStalls()) {
                if (this.isHmt) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Total stalled waves: <col=EF1020>" + this.stalls + "</col>", "");
                } else {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Total stalled waves: <col=EF1020>" + this.stalls + "</col>", "");
                }
            }
            if (this.config.showSplits()) {
                this.printSplits();
            }
            if (this.config.showBossRotation()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Boss rotation: [<col=EF1020>" + this.bossRotation[0] + "</col>] [<col=00FF0A>" + this.bossRotation[2] + "</col>] [<col=2536CA>" + this.bossRotation[1] + "</col>]", "");
            }
            this.reset();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        boolean inTob;
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        int tobVar = this.client.getVarbitValue(6440);
        boolean bl = inTob = tobVar == 2 || tobVar == 3;
        if (!inTob) {
            this.reset();
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        int npcId = npcChanged.getNpc().getId();
        switch (npcId) {
            case 8355: 
            case 10787: 
            case 10808: {
                this.bossRotation[0] = this.bossRotation[0] + 1;
                break;
            }
            case 8356: 
            case 10788: 
            case 10809: {
                this.bossRotation[1] = this.bossRotation[1] + 1;
                break;
            }
            case 8357: 
            case 10789: 
            case 10810: {
                this.bossRotation[2] = this.bossRotation[2] + 1;
            }
        }
    }

    private boolean inNyloRegion() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)13122);
    }

    @Provides
    NyloStatsConfig provideConfig(ConfigManager configManager) {
        return (NyloStatsConfig)configManager.getConfig(NyloStatsConfig.class);
    }

    private void printSplits() {
        String msgCap = "Pre cap splits: [<col=EF1020>" + this.preCapSplits[0] + "</col>] [<col=00FF0A>" + this.preCapSplits[1] + "</col>] [<col=2536CA>" + this.preCapSplits[2] + "</col>]";
        msgCap = msgCap + " Post cap splits: [<col=EF1020>" + (this.splits[0] - this.preCapSplits[0]) + "</col>] [<col=00FF0A>" + (this.splits[1] - this.preCapSplits[1]) + "</col>] [<col=2536CA>" + (this.splits[2] - this.preCapSplits[2]) + "</col>]";
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msgCap, "");
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Total splits: [<col=EF1020>" + this.splits[0] + "</col>] [<col=00FF0A>" + this.splits[1] + "</col>] [<col=2536CA>" + this.splits[2] + "</col>]", "");
    }

    private void printStalls() {
        block3: {
            block2: {
                if (this.config.showStalls() != StallDisplays.ALL && this.config.showStalls() != StallDisplays.ALL_ALIVE && this.config.showStalls() != StallDisplays.ALL_ALIVE_TOTAL) break block2;
                for (String msg : this.stallMessagesAll) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msg, "");
                }
                break block3;
            }
            if (this.config.showStalls() != StallDisplays.COLLAPSED) break block3;
            for (String msg : this.stallMessagesCollapsed) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msg, "");
            }
        }
    }

    private int hmtWavesCheck() {
        int hmtWaveThirty;
        if (this.currWave == 10) {
            int hmtWaveTen = waveNaturalStalls.get(this.currWave) + 8;
            if (this.ticksSinceLastWave < hmtWaveTen) {
                ++this.ticksSinceLastWave;
                return 1;
            }
        } else if (this.currWave == 30 && this.ticksSinceLastWave < (hmtWaveThirty = waveNaturalStalls.get(this.currWave) + 12)) {
            ++this.ticksSinceLastWave;
            return 1;
        }
        this.currCap = 15;
        return 0;
    }

    private void reset() {
        this.currWave = 0;
        this.ticksSinceLastWave = 0;
        this.stalls = 0;
        this.isHmt = false;
        this.currCap = 12;
        this.stallMessagesAll.clear();
        this.stallMessagesCollapsed.clear();
        this.splits = new int[3];
        this.preCapSplits = new int[3];
        this.bossRotation = new int[3];
        this.bossRotation[0] = 1;
    }

    static {
        waveNaturalStalls.put(1, 4);
        waveNaturalStalls.put(2, 4);
        waveNaturalStalls.put(3, 4);
        waveNaturalStalls.put(4, 4);
        waveNaturalStalls.put(5, 16);
        waveNaturalStalls.put(6, 4);
        waveNaturalStalls.put(7, 12);
        waveNaturalStalls.put(8, 4);
        waveNaturalStalls.put(9, 12);
        waveNaturalStalls.put(10, 8);
        waveNaturalStalls.put(11, 8);
        waveNaturalStalls.put(12, 8);
        waveNaturalStalls.put(13, 8);
        waveNaturalStalls.put(14, 8);
        waveNaturalStalls.put(15, 8);
        waveNaturalStalls.put(16, 4);
        waveNaturalStalls.put(17, 12);
        waveNaturalStalls.put(18, 8);
        waveNaturalStalls.put(19, 12);
        waveNaturalStalls.put(20, 16);
        waveNaturalStalls.put(21, 8);
        waveNaturalStalls.put(22, 12);
        waveNaturalStalls.put(23, 8);
        waveNaturalStalls.put(24, 8);
        waveNaturalStalls.put(25, 8);
        waveNaturalStalls.put(26, 4);
        waveNaturalStalls.put(27, 8);
        waveNaturalStalls.put(28, 4);
        waveNaturalStalls.put(29, 4);
        waveNaturalStalls.put(30, 4);
    }
}

