/*
 * Decompiled with CFR 0.152.
 */
package com.morghttpclient;

import java.util.Arrays;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;

public class ProfitTracker {
    private ItemManager itemManager;
    private Client client;

    public void ProfitTracker(Client client, ItemManager itemManager) {
        this.client = client;
        this.itemManager = itemManager;
    }

    public long calculateContainerValue(InventoryID ContainerID) {
        ItemContainer container = this.client.getItemContainer(ContainerID);
        if (container == null) {
            return 0L;
        }
        Item[] items = container.getItems();
        long newInventoryValue = ((Stream)Arrays.stream(items).parallel()).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item))).sum();
        return newInventoryValue;
    }

    public long calculateInventoryValue() {
        return this.calculateContainerValue(InventoryID.INVENTORY);
    }

    private long calculateItemValue(Item item) {
        int itemId = item.getId();
        if (itemId < -1) {
            return 0L;
        }
        if (itemId == -1) {
            return 0L;
        }
        return item.getQuantity() * this.itemManager.getItemPrice(itemId);
    }
}

