/*
 * Decompiled with CFR 0.152.
 */
package com.morghttpclient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.morghttpclient.HttpServerConfig;
import com.morghttpclient.XpTracker;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Morg HTTP Client", description="Actively logs the player status to localhost on port 8081.", tags={"status", "stats"}, enabledByDefault=true)
public class HttpServerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HttpServerPlugin.class);
    private static final Duration WAIT = Duration.ofSeconds(5L);
    @Inject
    public Client client;
    public Skill[] skillList;
    public XpTracker xpTracker;
    public Skill mostRecentSkillGained;
    public int tickCount = 0;
    public long startTime = 0L;
    public long currentTime = 0L;
    public int[] xp_gained_skills;
    @Inject
    public HttpServerConfig config;
    @Inject
    public ClientThread clientThread;
    public HttpServer server;
    public int MAX_DISTANCE = 1200;
    public String msg;

    @Provides
    private HttpServerConfig provideConfig(ConfigManager configManager) {
        return (HttpServerConfig)configManager.getConfig(HttpServerConfig.class);
    }

    protected void startUp() throws Exception {
        this.skillList = Skill.values();
        this.xpTracker = new XpTracker(this);
        this.server = HttpServer.create(new InetSocketAddress(8081), 0);
        this.server.createContext("/stats", this::handleStats);
        this.server.createContext("/inv", this.handlerForInv(InventoryID.INVENTORY));
        this.server.createContext("/equip", this.handlerForInv(InventoryID.EQUIPMENT));
        this.server.createContext("/events", this::handleEvents);
        this.server.setExecutor(Executors.newSingleThreadExecutor());
        this.startTime = System.currentTimeMillis();
        this.xp_gained_skills = new int[Skill.values().length];
        int skill_count = 0;
        this.server.start();
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            this.xp_gained_skills[skill_count] = 0;
            ++skill_count;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        this.msg = event.getMessage();
    }

    protected void shutDown() throws Exception {
        this.server.stop(1);
    }

    public Client getClient() {
        return this.client;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.currentTime = System.currentTimeMillis();
        this.xpTracker.update();
        int skill_count = 0;
        for (Skill skill : Skill.values()) {
            int xp_gained;
            if (skill == Skill.OVERALL) continue;
            this.xp_gained_skills[skill_count] = xp_gained = this.handleTracker(skill);
            ++skill_count;
        }
        ++this.tickCount;
    }

    public int handleTracker(Skill skill) {
        int startingSkillXp = this.xpTracker.getXpData(skill, 0);
        int endingSkillXp = this.xpTracker.getXpData(skill, this.tickCount);
        int xpGained = endingSkillXp - startingSkillXp;
        return xpGained;
    }

    public void handleStats(HttpExchange exchange) throws IOException {
        Player player = this.client.getLocalPlayer();
        JsonArray skills = new JsonArray();
        JsonObject headers = new JsonObject();
        headers.addProperty("username", this.client.getUsername());
        headers.addProperty("player name", player.getName());
        int skill_count = 0;
        skills.add((JsonElement)headers);
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            JsonObject object = new JsonObject();
            object.addProperty("stat", skill.getName());
            object.addProperty("level", (Number)this.client.getRealSkillLevel(skill));
            object.addProperty("boostedLevel", (Number)this.client.getBoostedSkillLevel(skill));
            object.addProperty("xp", (Number)this.client.getSkillExperience(skill));
            object.addProperty("xp gained", String.valueOf(this.xp_gained_skills[skill_count]));
            skills.add((JsonElement)object);
            ++skill_count;
        }
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
            RuneLiteAPI.GSON.toJson((JsonElement)skills, (Appendable)out);
        }
    }

    public void handleEvents(HttpExchange exchange) throws IOException {
        String npcName;
        this.MAX_DISTANCE = this.config.reachedDistance();
        Player player = this.client.getLocalPlayer();
        Actor npc = player.getInteracting();
        int minHealth = 0;
        int maxHealth = 0;
        if (npc != null) {
            npcName = npc.getName();
            int npcHealth = npc.getHealthScale();
            int npcHealth2 = npc.getHealthRatio();
            int health = 0;
            if (npcHealth2 > 0) {
                minHealth = 1;
                if (npcHealth > 1) {
                    if (npcHealth2 > 1) {
                        minHealth = (npcHealth * (npcHealth2 - 1) + npcHealth - 2) / (npcHealth - 1);
                    }
                    if ((maxHealth = (npcHealth * npcHealth2 - 1) / (npcHealth - 1)) > npcHealth) {
                        maxHealth = npcHealth;
                    }
                } else {
                    maxHealth = npcHealth;
                }
                health = (minHealth + maxHealth + 1) / 2;
            }
        } else {
            npcName = "null";
            boolean npcHealth = false;
            boolean npcHealth2 = false;
            boolean health = false;
        }
        JsonObject object = new JsonObject();
        JsonObject camera = new JsonObject();
        JsonObject worldPoint = new JsonObject();
        JsonObject mouse = new JsonObject();
        object.addProperty("animation", (Number)player.getAnimation());
        object.addProperty("animation pose", (Number)player.getPoseAnimation());
        object.addProperty("latest msg", this.msg);
        object.addProperty("run energy", (Number)this.client.getEnergy());
        object.addProperty("game tick", (Number)this.client.getGameCycle());
        object.addProperty("health", this.client.getBoostedSkillLevel(Skill.HITPOINTS) + "/" + this.client.getRealSkillLevel(Skill.HITPOINTS));
        object.addProperty("interacting code", String.valueOf(player.getInteracting()));
        object.addProperty("npc name", npcName);
        object.addProperty("npc health ", (Number)minHealth);
        object.addProperty("MAX_DISTANCE", (Number)this.MAX_DISTANCE);
        mouse.addProperty("x", (Number)this.client.getMouseCanvasPosition().getX());
        mouse.addProperty("y", (Number)this.client.getMouseCanvasPosition().getY());
        worldPoint.addProperty("x", (Number)player.getWorldLocation().getX());
        worldPoint.addProperty("y", (Number)player.getWorldLocation().getY());
        worldPoint.addProperty("plane", (Number)player.getWorldLocation().getPlane());
        worldPoint.addProperty("regionID", (Number)player.getWorldLocation().getRegionID());
        worldPoint.addProperty("regionX", (Number)player.getWorldLocation().getRegionX());
        worldPoint.addProperty("regionY", (Number)player.getWorldLocation().getRegionY());
        camera.addProperty("yaw", (Number)this.client.getCameraYaw());
        camera.addProperty("pitch", (Number)this.client.getCameraPitch());
        camera.addProperty("x", (Number)this.client.getCameraX());
        camera.addProperty("y", (Number)this.client.getCameraY());
        camera.addProperty("z", (Number)this.client.getCameraZ());
        camera.addProperty("x2", (Number)this.client.getCameraX2());
        camera.addProperty("y2", (Number)this.client.getCameraY2());
        camera.addProperty("z2", (Number)this.client.getCameraZ2());
        object.add("worldPoint", (JsonElement)worldPoint);
        object.add("camera", (JsonElement)camera);
        object.add("mouse", (JsonElement)mouse);
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
            RuneLiteAPI.GSON.toJson((JsonElement)object, (Appendable)out);
        }
    }

    private HttpHandler handlerForInv(InventoryID inventoryID) {
        return exchange -> {
            Item[] items = this.invokeAndWait(() -> {
                ItemContainer itemContainer = this.client.getItemContainer(inventoryID);
                if (itemContainer != null) {
                    return itemContainer.getItems();
                }
                return null;
            });
            if (items == null) {
                exchange.sendResponseHeaders(204, 0L);
                return;
            }
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                RuneLiteAPI.GSON.toJson((Object)items, (Appendable)out);
            }
        };
    }

    private <T> T invokeAndWait(Callable<T> r) {
        try {
            AtomicReference ref = new AtomicReference();
            Semaphore semaphore = new Semaphore(0);
            this.clientThread.invokeLater(() -> {
                try {
                    ref.set(r.call());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    semaphore.release();
                }
            });
            semaphore.acquire();
            return (T)ref.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

