/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.playtime;

import info.sigterm.plugins.playtime.PlayTimeOverlay;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Playtime", description="Shows an overlay of your accounts playtime")
public class PlayTimePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private PlayTimeOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private int startMinutes;
    private long startMs;
    String overlayText;

    protected void startUp() {
        this.overlayText = null;
        this.startMinutes = -1;
        this.startMs = 0L;
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.startMinutes = -1;
            }
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    public void tick() {
        int varcMinutes = this.client.getVarcIntValue(526);
        if (varcMinutes != this.startMinutes) {
            this.startMinutes = varcMinutes;
            this.startMs = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        int total = varcMinutes * 60 + (int)((now - this.startMs) / 1000L);
        int days = total / 86400;
        int hours = (total %= 84600) / 3600;
        int minutes = (total %= 3600) / 60;
        StringBuilder sb = new StringBuilder("Time played: ");
        if (days > 0) {
            sb.append(days).append(' ').append(days == 1 ? "day" : "days").append(' ');
        }
        if (hours > 0) {
            sb.append(hours).append(' ').append(hours == 1 ? "hour" : "hours").append(' ');
        }
        sb.append(minutes).append(' ').append(minutes == 1 ? "min" : "mins");
        this.overlayText = sb.toString();
    }
}

