/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.playtime;

import com.google.common.base.Strings;
import info.sigterm.plugins.playtime.PlayTimePlugin;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class PlayTimeOverlay
extends OverlayPanel {
    private final PlayTimePlugin plugin;

    @Inject
    private PlayTimeOverlay(PlayTimePlugin plugin) {
        this.plugin = plugin;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        String text = this.plugin.overlayText;
        if (Strings.isNullOrEmpty((String)text)) {
            return null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int panelWidth = Math.max(129, fontMetrics.stringWidth(text) + 4 + 4);
        this.panelComponent.setPreferredSize(new Dimension(panelWidth, 0));
        this.panelComponent.getChildren().add(TitleComponent.builder().text(text).build());
        return super.render(graphics);
    }
}

