/*
 * Decompiled with CFR 0.152.
 */
package com.chatfilterupdater;

import com.chatfilterupdater.ChatFilterUpdaterConfig;
import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Filter Updater", description="Automatically updates the chat filter regex patterns from a URL. Warning: Overwrites existing filter", tags={"chat", "filter", "update", "spam", "github"})
public class ChatFilterUpdaterPlugin
extends Plugin {
    private boolean isShuttingDown = false;
    private String regexBefore;
    private final Logger logger = LoggerFactory.getLogger(ChatFilterUpdaterPlugin.class);
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;

    @Provides
    ChatFilterUpdaterConfig provideConfig(ConfigManager configManager) {
        return (ChatFilterUpdaterConfig)configManager.getConfig(ChatFilterUpdaterConfig.class);
    }

    protected void startUp() throws Exception {
        this.isShuttingDown = false;
        this.regexBefore = this.configManager.getConfiguration("chatfilter", "filteredRegex");
        this.warningMessage();
        this.fetchPatternsFromGitHub();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"chatfilterupdater".equals(event.getGroup())) {
            return;
        }
        this.fetchPatternsFromGitHub();
    }

    private void setChatFilterRegex(String regex) {
        this.configManager.setConfiguration("chatfilter", "filteredRegex", regex);
    }

    private void updateChatFilter(String patterns) {
        if (patterns != null && !patterns.isBlank()) {
            this.setChatFilterRegex(patterns);
            this.client.refreshChat();
        }
    }

    private void fetchPatternsFromGitHub() {
        Request request = new Request.Builder().url(this.provideConfig(this.configManager).filterURL()).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                ChatFilterUpdaterPlugin.this.logger.error("Error fetching patterns from GitHub: " + e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    ChatFilterUpdaterPlugin.this.logger.error("Unexpected response code: " + response.code() + ", body: " + response.body().string());
                    return;
                }
                ResponseBody responseBody = response.body();
                if (responseBody != null && !ChatFilterUpdaterPlugin.this.isShuttingDown) {
                    String patterns = responseBody.string();
                    ChatFilterUpdaterPlugin.this.updateChatFilter(patterns);
                } else {
                    ChatFilterUpdaterPlugin.this.logger.error("Response body is null");
                }
            }
        });
    }

    protected void shutDown() throws Exception {
        this.isShuttingDown = true;
        this.configManager.setConfiguration("chatfilter", "filteredRegex", this.regexBefore);
    }

    private void warningMessage() {
        boolean hasShownStartupWarning = (Boolean)this.configManager.getConfiguration("chatfilterupdater", "hasShownStartupWarning", Boolean.class);
        if (!hasShownStartupWarning) {
            SwingUtilities.invokeLater(() -> {
                int result = JOptionPane.showConfirmDialog(null, "Warning: Enabling the Chat Filter Updater will permanently overwrite your existing chat filter regex and any changes made while the plugin is on will be lost. \nConsider making additions to the master chat filter on github. https://github.com/IamReallyOverrated/Runelite_ChatFilter/tree/master", "Chat Filter Updater Warning", 2, 2);
                if (result == 0) {
                    this.configManager.setConfiguration("chatfilterupdater", "hasShownStartupWarning", (Object)true);
                } else {
                    this.configManager.setConfiguration("chatfilter", "filteredRegex", this.regexBefore);
                }
            });
        }
    }
}

