/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstarstoclipboard;

import com.google.inject.Provides;
import com.shootingstarstoclipboard.ShootingStarsToClipboardConfig;
import com.shootingstarstoclipboard.TimesToShow;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stars to Clipboard", description="Puts shooting stars telescope predictions in your clipboard", tags={"Shooting", "Stars", "Star", "Clipboard"})
public class ShootingStarsToClipboardPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ShootingStarsToClipboardPlugin.class);
    private static final int STAR_BOX_WIDGET_GROUP = 229;
    private static final int STAR_BOX_WIDGET_CHILD = 1;
    private static final Pattern STAR_PATTERN = Pattern.compile("^You see a shooting star! The star looks like it will land ((?:in |on )(?:the )?((?:(?!\\bor\\b)[\\w' ])+)(?: or (?:in |on )?(?:the )?([\\w' ]+))? in the next (?:(\\d+) hours? )?(?:(\\d+)(?: minutes?)? )?to (?:(\\d+) hours? )?(?:(\\d+) minutes)?\\.)$");
    private boolean doProcessWidget;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ShootingStarsToClipboardConfig config;

    @Provides
    ShootingStarsToClipboardConfig provideConfig(ConfigManager configManager) {
        return (ShootingStarsToClipboardConfig)configManager.getConfig(ShootingStarsToClipboardConfig.class);
    }

    protected void startUp() throws Exception {
        this.doProcessWidget = false;
    }

    protected void shutDown() throws Exception {
        this.doProcessWidget = false;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.doProcessWidget) {
            this.doProcessWidget = false;
            Widget starBox = this.client.getWidget(229, 1);
            if (starBox != null) {
                Object copyText;
                Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);
                String text = Text.removeTags((String)starBox.getText().replace("<br>", " "));
                Matcher m = STAR_PATTERN.matcher(text);
                if (!m.matches()) {
                    return;
                }
                Instant from = this.getTime(now, m.group(4), m.group(5));
                Instant to = this.getTime(now, m.group(6), m.group(7));
                Instant eta = from.plus(Duration.between(from, to).dividedBy(2L));
                Object datePattern = "HH:mm";
                if (!this.config.useUTCTimes()) {
                    datePattern = (String)datePattern + " Z";
                }
                if (!this.config.useShortTimes()) {
                    datePattern = "yyyy-MM-dd " + (String)datePattern;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)datePattern).withZone(this.config.useUTCTimes() ? ZoneId.from(ZoneOffset.UTC) : ZoneId.systemDefault()).withLocale(Locale.UK);
                switch (this.config.copyFormat()) {
                    case TRUNCATED_TEXT: {
                        String t = m.group(1);
                        copyText = t.substring(0, 1).toUpperCase() + t.substring(1) + " " + this.getSuffixText(formatter, from, to, eta);
                        break;
                    }
                    case TAB_DELIMITED: {
                        copyText = this.getDelimitedText(m.group(2), m.group(3), "\t", formatter, from, to, eta);
                        break;
                    }
                    case COMMA_DELIMITED: {
                        copyText = this.getDelimitedText(m.group(2), m.group(3), ", ", formatter, from, to, eta);
                        break;
                    }
                    default: {
                        copyText = text + " " + this.getSuffixText(formatter, from, to, eta);
                    }
                }
                if (this.config.appendNewLine()) {
                    copyText = (String)copyText + System.lineSeparator();
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection((String)copyText), null);
                if (this.config.showChatMessage()) {
                    this.sendChatMessage(String.format("Shooting Stars info copied to clipboard for world %d.", this.client.getWorld()));
                }
            }
        }
    }

    private String getDelimitedText(String loc1, String loc2, String delim, DateTimeFormatter formatter, Instant from, Instant to, Instant eta) {
        Object loc = loc1;
        if (loc2 != null && this.config.showBothLocations()) {
            loc = (String)loc + "/" + loc2;
        }
        TimesToShow t = this.config.timesToShow();
        StringBuilder sb = new StringBuilder();
        sb.append(this.client.getWorld());
        if (this.config.showPVPIdentifier() && WorldType.isPvpWorld((Collection)this.client.getWorldType())) {
            sb.append(" (pvp)");
        }
        sb.append(delim).append((String)loc);
        if (t == TimesToShow.ALL || t == TimesToShow.FROM_TO_ONLY) {
            sb.append(delim).append(formatter.format(from)).append(delim).append(formatter.format(to));
        }
        if (t == TimesToShow.ALL || t == TimesToShow.ETA_ONLY) {
            sb.append(delim).append(formatter.format(eta));
        }
        return sb.toString();
    }

    private String getSuffixText(DateTimeFormatter formatter, Instant from, Instant to, Instant eta) {
        TimesToShow t = this.config.timesToShow();
        StringBuilder sb = new StringBuilder();
        sb.append("World: ").append(this.client.getWorld());
        if (this.config.showPVPIdentifier() && WorldType.isPvpWorld((Collection)this.client.getWorldType())) {
            sb.append(" (pvp)");
        }
        if (t == TimesToShow.ALL || t == TimesToShow.FROM_TO_ONLY) {
            sb.append(", From: ").append(formatter.format(from)).append(", To: ").append(formatter.format(to));
        }
        if (t == TimesToShow.ALL || t == TimesToShow.ETA_ONLY) {
            sb.append(", ETA: ").append(formatter.format(eta));
        }
        return sb.toString();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 229) {
            this.doProcessWidget = true;
        }
    }

    private void sendChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    private Instant getTime(Instant baseTime, String h, String m) {
        int hours = h != null ? Integer.parseInt(h) : 0;
        int minutes = m != null ? Integer.parseInt(m) : 0;
        return baseTime.plus(Duration.ofHours(hours)).plus(Duration.ofMinutes(minutes));
    }
}

