/*
 * Decompiled with CFR 0.152.
 */
package com.mogcounter;

import com.google.common.collect.EvictingQueue;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runelite.api.coords.WorldPoint;

class MOGSession {
    private static final Duration HOUR = Duration.ofHours(1L);
    private int lastMarksSpawned;
    private int marksSpawned;
    private Instant lastMarkSpawnTime;
    private int totalMarkSpawnEvents;
    private int spawnsPerHour;
    private final Map<WorldPoint, Integer> markTiles = new HashMap<WorldPoint, Integer>();
    private final Set<WorldPoint> ignoreTiles = new HashSet<WorldPoint>();
    private boolean isDirty;
    private EvictingQueue<Duration> markSpawnTimes = EvictingQueue.create((int)20);

    MOGSession() {
    }

    void addMarkTile(WorldPoint point, int markCount) {
        if (!this.ignoreTiles.contains(point)) {
            this.markTiles.put(point, markCount);
            this.isDirty = true;
        }
    }

    void addIgnoreTile(WorldPoint point) {
        this.ignoreTiles.add(point);
    }

    void removeMarkTile(WorldPoint point) {
        this.markTiles.remove(point);
        this.isDirty = true;
    }

    void removeIgnoreTile(WorldPoint point) {
        this.ignoreTiles.remove(point);
    }

    synchronized void checkMarkSpawned() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        this.marksSpawned = 0;
        for (int i : this.markTiles.values()) {
            this.marksSpawned += i;
        }
        if (this.marksSpawned > this.lastMarksSpawned) {
            Instant now = Instant.now();
            if (this.lastMarkSpawnTime != null) {
                this.markSpawnTimes.add((Object)Duration.between(this.lastMarkSpawnTime, now));
                this.calculateMarksPerHour();
            }
            this.lastMarkSpawnTime = now;
            ++this.totalMarkSpawnEvents;
        }
        this.lastMarksSpawned = this.marksSpawned;
    }

    private void calculateMarksPerHour() {
        int sz = this.markSpawnTimes.size();
        if (sz > 0) {
            Duration sum = Duration.ZERO;
            for (Duration markTime : this.markSpawnTimes) {
                sum = sum.plus(markTime);
            }
            this.spawnsPerHour = (int)(HOUR.toMillis() / sum.dividedBy(sz).toMillis());
        } else {
            this.spawnsPerHour = 0;
        }
    }

    void clearCounters() {
        this.lastMarksSpawned = 0;
        this.lastMarkSpawnTime = null;
        this.markSpawnTimes.clear();
        this.marksSpawned = 0;
        this.totalMarkSpawnEvents = 0;
        this.spawnsPerHour = 0;
        this.markTiles.clear();
        this.ignoreTiles.clear();
        this.isDirty = false;
    }

    void clearSpawnedMarks() {
        this.marksSpawned = 0;
        this.lastMarksSpawned = 0;
        this.markTiles.clear();
        this.ignoreTiles.clear();
        this.isDirty = false;
    }

    int getMarksSpawned() {
        return this.marksSpawned;
    }

    Instant getLastMarkSpawnTime() {
        return this.lastMarkSpawnTime;
    }

    int getTotalMarkSpawnEvents() {
        return this.totalMarkSpawnEvents;
    }

    int getSpawnsPerHour() {
        return this.spawnsPerHour;
    }
}

