/*
 * Decompiled with CFR 0.152.
 */
package com.mogcounter;

import com.google.inject.Provides;
import com.mogcounter.MOGCounterConfig;
import com.mogcounter.MOGCounterOverlay;
import com.mogcounter.MOGSession;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.TileItem;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Marks of Grace Counter", description="Counts Marks of Grace spawns", tags={"marks", "grace", "agility", "counter"})
public class MOGCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MOGCounterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MOGCounterConfig config;
    @Inject
    private MOGCounterOverlay mogOverlay;
    private MOGSession mogSession;

    @Provides
    MOGCounterConfig getConfig(ConfigManager configManager) {
        return (MOGCounterConfig)configManager.getConfig(MOGCounterConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.mogOverlay);
        this.mogSession = new MOGSession();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.mogOverlay);
        this.mogSession = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.mogSession = null;
                break;
            }
            case LOGGED_IN: {
                if (this.mogSession != null) break;
                this.mogSession = new MOGSession();
            }
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        if (item.getId() == 11849) {
            WorldPoint wp = itemSpawned.getTile().getWorldLocation();
            Player player = this.client.getLocalPlayer();
            if (player != null) {
                if (wp.equals((Object)player.getWorldLocation())) {
                    this.mogSession.addIgnoreTile(wp);
                } else {
                    this.mogSession.addMarkTile(wp, item.getQuantity());
                }
            }
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        if (item.getId() == 11849) {
            WorldPoint wp = itemDespawned.getTile().getWorldLocation();
            Player player = this.client.getLocalPlayer();
            if (player != null) {
                if (wp.equals((Object)player.getWorldLocation())) {
                    this.mogSession.removeIgnoreTile(wp);
                }
                this.mogSession.removeMarkTile(wp);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.mogSession != null) {
            this.mogSession.checkMarkSpawned();
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked overlayMenuClicked) {
        OverlayMenuEntry overlayMenuEntry = overlayMenuClicked.getEntry();
        if (overlayMenuEntry.getMenuAction() == MenuAction.RUNELITE_OVERLAY && overlayMenuClicked.getOverlay() == this.mogOverlay) {
            switch (overlayMenuClicked.getEntry().getOption()) {
                case "Clear": {
                    this.mogSession.clearCounters();
                    break;
                }
                case "Reset Ground Counter": {
                    this.mogSession.clearSpawnedMarks();
                }
            }
        }
    }

    public MOGSession getMogSession() {
        return this.mogSession;
    }
}

