/*
 * Decompiled with CFR 0.152.
 */
package com.mogcounter;

import com.mogcounter.MOGCounterConfig;
import com.mogcounter.MOGCounterPlugin;
import com.mogcounter.MOGSession;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class MOGCounterOverlay
extends OverlayPanel {
    static final String MARK_CLEAR = "Clear";
    static final String GROUND_RESET = "Reset Ground Counter";
    private final MOGCounterPlugin plugin;
    private final MOGCounterConfig config;

    @Inject
    private MOGCounterOverlay(MOGCounterPlugin plugin, MOGCounterConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Mark overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, GROUND_RESET, "Mark overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, MARK_CLEAR, "Mark overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        MOGSession session = this.plugin.getMogSession();
        if (!this.config.showMarkCount() || session == null || session.getLastMarkSpawnTime() == null) {
            return null;
        }
        Duration markTimeout = Duration.ofMinutes(this.config.markTimeout());
        Duration sinceMark = Duration.between(session.getLastMarkSpawnTime(), Instant.now());
        if (sinceMark.compareTo(markTimeout) >= 0) {
            session.clearCounters();
            return null;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Marks of Grace").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total Spawns:").right(Integer.toString(session.getTotalMarkSpawnEvents())).build());
        if (this.config.showMarksSpawned()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Marks on Ground:").right(Integer.toString(session.getMarksSpawned())).build());
        }
        if (this.config.showMarkLastSpawn()) {
            long s = sinceMark.getSeconds();
            this.panelComponent.getChildren().add(LineComponent.builder().left("Last Spawn:").right(String.format("%d:%02d", s % 3600L / 60L, s % 60L)).build());
        }
        if (this.config.showMarksPerHour() && session.getTotalMarkSpawnEvents() >= 2) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Spawns per Hour:").right(Integer.toString(session.getSpawnsPerHour())).build());
        }
        return super.render(graphics);
    }
}

