/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PickpocketGuardianConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pickpocket Guardian")
public class PickpocketGuardianPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PickpocketGuardianPlugin.class);
    private static final String OPTION_CHECK_FOR_SNAKES = "Check for Snakes";
    private static final String OPTION_OPEN = "Open";
    private static final String OPTION_PASS = "Pass";
    private static final String OPTION_PICKPOCKET = "Pickpocket";
    private static final String OPTION_SEARCH = "Search";
    private static final String OBJECT_URN = "Urn";
    private static final String OBJECT_SARCOPHAGUS = "Sarcophagus";
    private static final String OBJECT_SPEARTRAP = "Speartrap";
    private static final int MAX_DAMAGE_URN = 4;
    private static final int MAX_DAMAGE_SPEARTRAP = 4;
    @Inject
    private Client client;
    @Inject
    private PickpocketGuardianConfig config;

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        String targetName;
        String optionName;
        block8: {
            block10: {
                int currentHealth;
                block9: {
                    currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
                    optionName = menuOptionClicked.getMenuEntry().getOption();
                    targetName = menuOptionClicked.getMenuTarget().toString();
                    targetName = targetName.substring(targetName.lastIndexOf(">") + 1);
                    if (currentHealth <= this.config.getHitpointsThreshold()) {
                        if (optionName.equals(OPTION_PICKPOCKET)) {
                            menuOptionClicked.consume();
                            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Current health at or below the set threshold! Eat some food.", "Pickpocket Safe Guard");
                        }
                    }
                    if (!this.config.getSafeUrnOpenings()) break block8;
                    if (currentHealth > 4) break block9;
                    if (!targetName.equals(OBJECT_URN)) break block9;
                    if (optionName.equals(OPTION_SEARCH)) break block10;
                    if (optionName.equals(OPTION_CHECK_FOR_SNAKES)) break block10;
                }
                if (currentHealth > 4) break block8;
                if (!targetName.equals(OBJECT_SPEARTRAP)) break block8;
                if (!optionName.equals(OPTION_PASS)) break block8;
            }
            menuOptionClicked.consume();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Interacting with the " + targetName.toLowerCase() + " may kill you! Eat some food.", "Pickpocket Safe Guard");
        }
        if (this.config.getPreventSarcophagus()) {
            if (targetName.contains(OBJECT_SARCOPHAGUS)) {
                if (optionName.equals(OPTION_OPEN)) {
                    menuOptionClicked.consume();
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Pickpocket Guardian prevented opening the sarcophagus.", "Pickpocket Safe Guard");
                }
            }
        }
    }

    @Provides
    PickpocketGuardianConfig provideConfig(ConfigManager configManager) {
        return (PickpocketGuardianConfig)configManager.getConfig(PickpocketGuardianConfig.class);
    }
}

