/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc.proto.path;

import abex.os.keepassxc.proto.path.NativeMessagingManifest;
import com.google.common.base.Strings;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import net.runelite.client.util.OSType;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPathResolver {
    private static final Logger log = LoggerFactory.getLogger(ProxyPathResolver.class);
    private static String proxyPath;

    private ProxyPathResolver() {
    }

    public static String getKeepassProxyPath() {
        if (proxyPath == null) {
            ProxyPathResolver.setProxyPath();
        }
        if (proxyPath == null) {
            log.warn("Could not locate keepass-proxy");
            proxyPath = "keepassxc-proxy";
        }
        return proxyPath;
    }

    private static boolean setProxyPath() {
        switch (OSType.getOSType()) {
            case MacOS: {
                return ProxyPathResolver.testOSXBrowser("Google/Chrome") || ProxyPathResolver.testOSXBrowser("Mozilla") || ProxyPathResolver.testOSXBrowser("Chromium") || ProxyPathResolver.testOSXBrowser("Vivaldi") || ProxyPathResolver.testOSXBrowser("BraveSoftware/Brave-Browser") || ProxyPathResolver.testOSXBrowser("Microsoft Edge");
            }
            case Linux: {
                File home = new File(System.getProperty("user.home"));
                File config = new File(home, ".config");
                File config2 = new File(home, "/etc/xdg");
                return ProxyPathResolver.testManifestDir(new File(config, "/google-chrome/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config2, "/google-chrome/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(home, "/.mozilla/native-messaging-hosts")) || ProxyPathResolver.testManifestDir(new File(config, "/chromium/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config2, "/chromium/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config, "/vivaldi/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config2, "/vivaldi/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config, "/BraveSoftware/Brave-Browser/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config2, "/BraveSoftware/Brave-Browser/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config, "/microsoftedge/NativeMessagingHosts")) || ProxyPathResolver.testManifestDir(new File(config2, "/microsoftedge/NativeMessagingHosts"));
            }
            case Windows: {
                return ProxyPathResolver.testWindowsBrowser("Google\\Chrome") || ProxyPathResolver.testWindowsBrowser("Chromium") || ProxyPathResolver.testWindowsBrowser("Mozilla") || ProxyPathResolver.testWindowsBrowser("Microsoft\\Edge");
            }
        }
        return false;
    }

    private static boolean testPath(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            log.info("proxy is not at \"{}\"", (Object)file);
            return false;
        }
        proxyPath = file.getAbsolutePath();
        return true;
    }

    private static boolean testOSXBrowser(String name) {
        return ProxyPathResolver.testManifestDir(new File(System.getProperty("user.home"), "/Library/Application Support/" + name + "/NativeMessagingHosts"));
    }

    private static boolean testManifestDir(File nativeHostsPath) {
        return ProxyPathResolver.testManifest(new File(nativeHostsPath, "org.keepassxc.keepassxc_browser.json"));
    }

    private static boolean testManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            return false;
        }
        try {
            String manifestJson = new String(Files.readAllBytes(manifestFile.toPath()), StandardCharsets.UTF_8);
            NativeMessagingManifest manifest = (NativeMessagingManifest)RuneLiteAPI.GSON.fromJson(manifestJson, NativeMessagingManifest.class);
            return ProxyPathResolver.testPath(new File(manifest.getPath()));
        }
        catch (Exception e) {
            log.debug("Failed to read manifest file", (Throwable)e);
            return false;
        }
    }

    private static boolean testWindowsBrowser(String browser) {
        String regKey = "Software\\" + browser + "\\NativeMessagingHosts\\org.keepassxc.keepassxc_browser";
        try {
            String manifestFile = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)regKey, (String)"");
            return !Strings.isNullOrEmpty((String)manifestFile) && ProxyPathResolver.testManifest(new File(manifestFile));
        }
        catch (Win32Exception e) {
            log.debug("Failed to read registry key {}", (Object)regKey);
            return false;
        }
    }
}

