/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc.proto;

import abex.os.keepassxc.proto.Base64Adapter;
import abex.os.keepassxc.proto.InterruptableInputStream;
import abex.os.keepassxc.proto.KeePassException;
import abex.os.keepassxc.proto.Key;
import abex.os.keepassxc.proto.msg.Associate;
import abex.os.keepassxc.proto.msg.ChangePublicKeys;
import abex.os.keepassxc.proto.msg.GetDatabaseHash;
import abex.os.keepassxc.proto.msg.TestAssociate;
import abex.os.keepassxc.proto.path.ProxyPathResolver;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.neilalexander.jnacl.NaCl;
import com.neilalexander.jnacl.crypto.curve25519xsalsa20poly1305;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeePassXCSocket
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(KeePassXCSocket.class);
    private static final int KEY_SIZE = 32;
    private static final int ID_SIZE = 24;
    private final Gson gson;
    private final Process proc;
    private final InterruptableInputStream stdoutInterrupt;
    private final LittleEndianDataOutputStream stdin;
    private final LittleEndianDataInputStream stdout;
    private final byte[] clientID = new byte[24];
    private final byte[] publicKey = new byte[32];
    private NaCl nacl;
    private Map<String, Key> keyring = new HashMap<String, Key>();
    private final SecureRandom secureRandom = new SecureRandom();

    public KeePassXCSocket(Gson clientGson) throws IOException {
        String keepassProxyPath = ProxyPathResolver.getKeepassProxyPath();
        if (keepassProxyPath == null) {
            throw KeePassException.create(0, "Could not locate keepass-proxy.");
        }
        this.gson = clientGson.newBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(byte[].class, (Object)new Base64Adapter()).create();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(keepassProxyPath, "", "keepassxc-browser@keepassxc.org");
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.environment().put("MOZ_LAUNCHED_CHILD", "1");
        this.proc = pb.start();
        this.stdin = new LittleEndianDataOutputStream(this.proc.getOutputStream());
        this.stdoutInterrupt = new InterruptableInputStream(this.proc.getInputStream());
        this.stdout = new LittleEndianDataInputStream((InputStream)this.stdoutInterrupt);
    }

    public void setDeadline(long ms) {
        this.stdoutInterrupt.setDeadline(ms);
    }

    public void clearDeadline() {
        this.stdoutInterrupt.clearDeadline();
    }

    public void init() throws IOException {
        byte[] privateKey = new byte[32];
        this.secureRandom.nextBytes(this.clientID);
        curve25519xsalsa20poly1305.crypto_box_keypair(this.publicKey, privateKey);
        byte[] nonce = new byte[24];
        this.secureRandom.nextBytes(nonce);
        byte[] msg = this.gson.toJson((Object)ChangePublicKeys.Request.builder().nonce(nonce).clientID(this.clientID).publicKey(this.publicKey).build()).getBytes(StandardCharsets.UTF_8);
        this.stdin.writeInt(msg.length);
        this.stdin.write(msg);
        this.stdin.flush();
        this.increment(nonce);
        byte[] rs = new byte[this.stdout.readInt()];
        this.stdout.readFully(rs);
        ChangePublicKeys.Response r = (ChangePublicKeys.Response)this.gson.fromJson(new String(rs, StandardCharsets.UTF_8), ChangePublicKeys.Response.class);
        if (!Arrays.equals(r.getNonce(), nonce)) {
            throw new IOException("Incorrect nonce: " + Arrays.toString(r.getNonce()) + " != " + Arrays.toString(nonce));
        }
        if (!r.isSuccess()) {
            throw new IOException("success == false");
        }
        byte[] serverPublicKey = r.getPublicKey();
        try {
            this.nacl = new NaCl(privateKey, serverPublicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ensureAssociate();
    }

    private void increment(byte[] nonce) {
        int carry = 1;
        for (int i = 0; i < nonce.length; ++i) {
            int v = (nonce[i] & 0xFF) + carry;
            nonce[i] = (byte)v;
            carry = v >>> 8;
        }
    }

    public synchronized <T> T call(String action, Object send, Class<T> type) throws IOException {
        byte[] nonce = new byte[24];
        this.secureRandom.nextBytes(nonce);
        byte[] rawMsg = this.gson.toJson(send).getBytes(StandardCharsets.UTF_8);
        byte[] cryptMsgAndGarbage = this.nacl.encrypt(rawMsg, nonce);
        byte[] cryptMsg = new byte[cryptMsgAndGarbage.length - 16];
        System.arraycopy(cryptMsgAndGarbage, 16, cryptMsg, 0, cryptMsg.length);
        byte[] wrappedMsg = this.gson.toJson((Object)new RequestWrapper(action, cryptMsg, nonce, this.clientID)).getBytes(StandardCharsets.UTF_8);
        this.stdin.writeInt(wrappedMsg.length);
        this.stdin.write(wrappedMsg);
        this.stdin.flush();
        this.increment(nonce);
        byte[] rs = new byte[this.stdout.readInt()];
        this.stdoutInterrupt.refreshDeadline();
        this.stdout.readFully(rs);
        ResponseWrapper res = (ResponseWrapper)this.gson.fromJson(new String(rs, StandardCharsets.UTF_8), ResponseWrapper.class);
        if (res.error != null) {
            throw KeePassException.create(res.errorCode, res.error);
        }
        byte[] cryptResAndGarbage = new byte[res.message.length + 16];
        System.arraycopy(res.message, 0, cryptResAndGarbage, 16, res.message.length);
        byte[] rawRes = this.nacl.decrypt(cryptResAndGarbage, res.nonce);
        String resStr = new String(rawRes, StandardCharsets.UTF_8);
        ResponseShared meta = (ResponseShared)this.gson.fromJson(resStr, ResponseShared.class);
        if (!meta.success) {
            throw KeePassException.create(meta.errorCode, meta.error);
        }
        if (!Arrays.equals(meta.nonce, nonce)) {
            throw new IOException("Nonce mismatch " + Arrays.toString(meta.nonce) + " != " + Arrays.toString(nonce));
        }
        return (T)this.gson.fromJson(resStr, type);
    }

    protected File getKeyringFile() {
        return new File(RuneLite.RUNELITE_DIR, "keepassxc.keyring");
    }

    synchronized void ensureAssociate() throws IOException {
        GetDatabaseHash.Response hashRes = this.call("get-databasehash", new GetDatabaseHash.Request(), GetDatabaseHash.Response.class);
        String hash = hashRes.getHash();
        Key k = this.keyring.get(hash);
        if (k != null) {
            try {
                this.call("test-associate", TestAssociate.Request.builder().id(k.id).key(k.key).build(), TestAssociate.Response.class);
                return;
            }
            catch (IOException e) {
                log.debug("", (Throwable)e);
            }
        }
        try {
            this.keyring = (Map)this.gson.fromJson(new String(Files.readAllBytes(this.getKeyringFile().toPath()), StandardCharsets.UTF_8), new TypeToken<Map<String, Key>>(){}.getType());
        }
        catch (IOException e) {
            log.info("failed to read keyring", (Throwable)e);
        }
        k = this.keyring.get(hash);
        if (k != null) {
            this.call("test-associate", TestAssociate.Request.builder().id(k.id).key(k.key).build(), TestAssociate.Response.class);
            return;
        }
        this.clearDeadline();
        byte[] idKey = new byte[32];
        this.secureRandom.nextBytes(idKey);
        k = new Key(this.call("associate", Associate.Request.builder().idKey(idKey).key(this.publicKey).build(), Associate.Response.class).getId(), idKey);
        this.keyring.put(hash, k);
        try {
            Files.write(this.getKeyringFile().toPath(), this.gson.toJson(this.keyring).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            log.info("failed to write keyring", (Throwable)e);
        }
    }

    public Collection<Key> getKeys() {
        return Collections.unmodifiableCollection(this.keyring.values());
    }

    @Override
    public void close() throws IOException {
        this.stdin.close();
        this.proc.destroy();
    }

    private static class ResponseShared {
        byte[] nonce;
        boolean success;
        String error;
        int errorCode;

        private ResponseShared() {
        }
    }

    private static class ResponseWrapper {
        byte[] message;
        byte[] nonce;
        String error;
        int errorCode;

        private ResponseWrapper() {
        }
    }

    private static class RequestWrapper {
        String action;
        byte[] message;
        byte[] nonce;
        byte[] clientID;

        public RequestWrapper(String action, byte[] message, byte[] nonce, byte[] clientID) {
            this.action = action;
            this.message = message;
            this.nonce = nonce;
            this.clientID = clientID;
        }
    }
}

