/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc.proto;

import abex.os.keepassxc.proto.DatabaseClosedException;
import abex.os.keepassxc.proto.NoLoginsFound;
import java.io.IOException;

public class KeePassException
extends IOException {
    private final int errorCode;

    protected KeePassException(int code, String message) {
        super(message);
        this.errorCode = code;
    }

    public static KeePassException create(int code, String message) {
        switch (code) {
            case 1: {
                return new DatabaseClosedException(code, message);
            }
            case 15: {
                return new NoLoginsFound(code, message);
            }
        }
        return new KeePassException(code, message + "(" + code + ")");
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

