/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc.proto;

import abex.os.keepassxc.proto.IOTimeoutException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InterruptableInputStream
extends FilterInputStream {
    private long deadline = 0L;
    private long timeout = 0L;

    public InterruptableInputStream(InputStream in) {
        super(in);
    }

    public void setDeadline(long ms) {
        this.timeout = ms * 1000000L;
        this.refreshDeadline();
    }

    public void clearDeadline() {
        this.timeout = 0L;
        this.deadline = 0L;
    }

    public void refreshDeadline() {
        if (this.timeout > 0L) {
            this.deadline = System.nanoTime() + this.timeout;
        }
    }

    private void check() throws IOException {
        if (this.deadline != 0L && System.nanoTime() > this.deadline) {
            throw new IOTimeoutException();
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new IOTimeoutException(e);
        }
    }

    @Override
    public int read() throws IOException {
        while (this.in.available() <= 0) {
            this.check();
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (true) {
            int thisread;
            int avail;
            if ((avail = this.available()) <= 0) {
                this.check();
                continue;
            }
            if (avail > len) {
                avail = len;
            }
            if ((thisread = this.in.read(b, off, avail)) < 0) {
                return read;
            }
            read += thisread;
            off += thisread;
            if ((len -= thisread) <= 0) break;
        }
        return read;
    }
}

