/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc;

import abex.os.keepassxc.KeePassXcConfig;
import abex.os.keepassxc.KeePassXcPanel;
import com.google.inject.Provides;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="KeePassXC")
public class KeePassXcPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(KeePassXcPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeePassXcConfig config;
    private KeePassXcPanel panel;
    private int lastLoginState = -1;
    private boolean isTicking = false;

    public void startUp() {
        this.panel = (KeePassXcPanel)((Object)this.injector.getInstance(KeePassXcPanel.class));
        this.lastLoginState = -1;
        this.updatePanel(this.client.getGameState());
    }

    public void shutDown() {
        this.panel.close();
        this.isTicking = false;
    }

    @Provides
    KeePassXcConfig getConfig(ConfigManager configManager) {
        return (KeePassXcConfig)configManager.getConfig(KeePassXcConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged ev) {
        this.updatePanel(ev.getGameState());
    }

    private void updatePanel(GameState gs) {
        SwingUtilities.invokeLater(() -> {
            switch (gs) {
                case LOGIN_SCREEN: 
                case LOGIN_SCREEN_AUTHENTICATOR: {
                    if (this.isTicking) break;
                    this.isTicking = true;
                    this.clientThread.invokeLater(() -> {
                        if (!this.isTicking) {
                            SwingUtilities.invokeLater(() -> this.onLoginStateChanged(-1));
                            return true;
                        }
                        int loginState = this.client.getLoginIndex();
                        if (loginState != this.lastLoginState) {
                            this.lastLoginState = loginState;
                            SwingUtilities.invokeLater(() -> this.onLoginStateChanged(loginState));
                        }
                        return false;
                    });
                    break;
                }
                default: {
                    this.isTicking = false;
                    this.panel.close();
                }
            }
        });
    }

    private void onLoginStateChanged(int loginState) {
        if (loginState == 2) {
            this.panel.load();
        } else {
            this.panel.close();
        }
    }
}

