/*
 * Decompiled with CFR 0.152.
 */
package abex.os.keepassxc;

import abex.os.keepassxc.KeePassXcConfig;
import abex.os.keepassxc.KeePassXcPlugin;
import abex.os.keepassxc.proto.DatabaseClosedException;
import abex.os.keepassxc.proto.IOTimeoutException;
import abex.os.keepassxc.proto.KeePassXCSocket;
import abex.os.keepassxc.proto.NoLoginsFound;
import abex.os.keepassxc.proto.msg.GetLogins;
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeePassXcPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(KeePassXcPanel.class);
    private static final String URL = "https://secure.runescape.com/";
    private final Client client;
    private final ClientToolbar clientToolbar;
    private final NavigationButton button;
    @Inject
    private KeePassXcConfig config;
    @Inject
    private Gson gson;

    @Inject
    public KeePassXcPanel(Client client, ClientToolbar clientToolbar) {
        this.client = client;
        this.clientToolbar = clientToolbar;
        this.button = NavigationButton.builder().icon(ImageUtil.loadImageResource(KeePassXcPlugin.class, (String)"icon.png")).panel((PluginPanel)this).priority(999).tooltip("KeePassXC").build();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public void load() {
        Thread t = new Thread(() -> {
            String message;
            IOException ex;
            try (KeePassXCSocket sock = new KeePassXCSocket(this.gson);){
                sock.setDeadline(500L);
                sock.init();
                sock.clearDeadline();
                GetLogins.Response r = sock.call("get-logins", GetLogins.Request.builder().action("get-logins").url(URL).keys(sock.getKeys()).build(), GetLogins.Response.class);
                SwingUtilities.invokeLater(() -> this.open(r));
                return;
            }
            catch (NoLoginsFound e) {
                ex = e;
                message = "No logins found for \"https://secure.runescape.com/\"";
            }
            catch (DatabaseClosedException e) {
                ex = e;
                message = "The database is locked";
            }
            catch (IOTimeoutException e) {
                ex = e;
                message = "<html>Cannot connect to KeePassXC. Check that:<br>1) KeePassXC is open, and<br>2)<a href=\"https://github.com/abextm/keepassxc-runelite\">Browser Integration</a> is enabled<br>";
            }
            catch (IOException e) {
                ex = e;
                message = e.toString();
            }
            catch (Throwable e) {
                log.warn("error connecting to KeePassXC", e);
                return;
            }
            log.warn("error connecting to KeePassXC", (Throwable)ex);
            SwingUtilities.invokeLater(() -> this.open(message));
        }, "KeePassXCSocketConnection");
        t.setDaemon(true);
        t.start();
    }

    public void open(GetLogins.Response logins) {
        SwingUtil.fastRemoveAll((Container)((Object)this));
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 0));
        KeePassXcConfig.UsernameVisibility vis = this.config.usernameVisibility();
        boolean hideUsernames = vis == KeePassXcConfig.UsernameVisibility.AUTO ? this.client.getPreferences().getHideUsername() : vis == KeePassXcConfig.UsernameVisibility.NEVER;
        String defaultTitle = this.config.defaultTitle().trim();
        for (GetLogins.Entry e : logins.getEntries()) {
            if (!defaultTitle.isEmpty() && e.getName().trim().equalsIgnoreCase(defaultTitle)) {
                this.fillCredentials(e);
            }
            String name = hideUsernames ? e.getName() : e.getLogin();
            JButton b = new JButton(name);
            b.addActionListener(_e -> this.fillCredentials(e));
            this.add(b);
        }
        this.open();
    }

    public void open(String error) {
        SwingUtil.fastRemoveAll((Container)((Object)this));
        this.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel("KeePassXC");
        titleLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        this.add(titleLabel, "North");
        JLabel errorLabel = new JLabel(error);
        errorLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(errorLabel, "Center");
        JButton button = new JButton("Retry");
        this.add(button, "South");
        button.addActionListener(e -> this.load());
        this.open();
    }

    private void open() {
        this.revalidate();
        this.clientToolbar.addNavigation(this.button);
        if (!this.button.isSelected() && this.config.autoOpenPanel()) {
            SwingUtilities.invokeLater(() -> this.button.getOnSelect().run());
        }
    }

    public void close() {
        this.button.setSelected(false);
        this.clientToolbar.removeNavigation(this.button);
    }

    private void fillCredentials(GetLogins.Entry e) {
        this.client.setPassword(e.getPassword());
        this.client.setUsername(e.getLogin());
        if (e.getTotp() != null && this.config.performTotp()) {
            this.client.setOtp(e.getTotp());
        } else {
            this.client.setOtp("");
        }
    }
}

