/*
 * Decompiled with CFR 0.152.
 */
package com.rc_lap_tracker;

import com.google.inject.Provides;
import com.rc_lap_tracker.RCLapTrackerConfig;
import com.rc_lap_tracker.jwowWriteableCounter;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="RC Lap Tracker", description="Shows you how many laps until your largest pouch degrades", tags={"rc", "runecraft", "rune", "lap", "tracker", "pouch", "essence", "zmi"})
public class RCLapTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RCLapTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RCLapTrackerConfig config;
    @Inject
    private ItemManager itemManager;
    private jwowWriteableCounter counterBox;
    private long lastAction;
    private int target;
    private int cycle;
    private boolean hasCrafted;
    private boolean isMidRun;
    private boolean isActive;
    private static final int SPELL_CONTACT_ANIMATION_ID = 4413;
    private static final int CRAFT_RUNES_ANIMATION_ID = 791;

    @Provides
    RCLapTrackerConfig getConfig(ConfigManager configManager) {
        return (RCLapTrackerConfig)configManager.getConfig(RCLapTrackerConfig.class);
    }

    private int getIntConfig(String key) {
        Integer value = (Integer)this.configManager.getRSProfileConfiguration("rc-lap-tracker", key, Integer.TYPE);
        return value == null ? -1 : value;
    }

    private boolean getBooleanConfig(String key) {
        Boolean value = (Boolean)this.configManager.getRSProfileConfiguration("rc-lap-tracker", key, Boolean.TYPE);
        return value != null && value != false;
    }

    private void setConfig(String key, Object value) {
        this.configManager.setRSProfileConfiguration("rc-lap-tracker", key, value);
    }

    protected void startUp() {
        this.cycle = this.getIntConfig("cycle");
        this.hasCrafted = this.getBooleanConfig("hascrafted");
        this.isMidRun = this.getBooleanConfig("ismidrun");
        this.counterBox = null;
        this.lastAction = System.currentTimeMillis();
        this.updateInfoBox();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean wasActive = this.isActive;
        this.isActive = System.currentTimeMillis() - this.lastAction < 300000L;
        if (wasActive != this.isActive) {
            this.updateInfoBox();
        }
    }

    protected void shutDown() throws Exception {
        this.setConfig("cycle", this.cycle);
        this.setConfig("hascrafted", this.hasCrafted);
        this.setConfig("ismidrun", this.isMidRun);
        this.removeInfobox();
    }

    private void removeInfobox() {
        if (this.counterBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.counterBox);
        }
        this.counterBox = null;
    }

    private void updateInfoBox() {
        if (!this.isActive) {
            this.removeInfobox();
            return;
        }
        if (this.counterBox == null) {
            AsyncBufferedImage image = this.itemManager.getImage(21880, 1, false);
            this.counterBox = new jwowWriteableCounter((BufferedImage)image, this, this.cycle);
            this.infoBoxManager.addInfoBox((InfoBox)this.counterBox);
        }
        this.counterBox.count = this.cycle;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        if (!this.client.getLocalPlayer().getName().equals(event.getActor().getName())) {
            return;
        }
        int animId = event.getActor().getAnimation();
        if (animId == 4413) {
            this.cycle = this.target;
            this.isMidRun = false;
            this.lastAction = System.currentTimeMillis();
            this.updateInfoBox();
        } else if (animId == 791 && !this.hasCrafted && this.cycle > 0) {
            this.hasCrafted = true;
            this.isMidRun = true;
            this.lastAction = System.currentTimeMillis();
            --this.cycle;
            this.updateInfoBox();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.BANK.getId()) {
            this.hasCrafted = false;
            this.target = 0;
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            if (inventory != null) {
                if (inventory.contains(26784)) {
                    this.target = 8;
                } else if (inventory.contains(5514)) {
                    this.target = 10;
                } else if (inventory.contains(5512)) {
                    this.target = 29;
                } else if (inventory.contains(5510)) {
                    this.target = 45;
                }
            }
            if (!this.isMidRun) {
                this.cycle = this.target;
                this.updateInfoBox();
            }
        }
    }
}

