/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.sololegends.runelite.TempleTrekkingBogHelperConfig;
import com.sololegends.runelite.TempleTrekkingBogHelperOverlay;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Temple Trek Bog Helper", description="Highlights firm bog ground as you find them", tags={"temple", "trek", "trekking", "bog", "help", "solve"})
public class TempleTrekkingBogHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TempleTrekkingBogHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TempleTrekkingBogHelperOverlay bog_overlay;
    @Inject
    private OverlayManager overlay_manager;

    protected void startUp() throws Exception {
        log.info("Starting Temple Trek Bog Helper");
        this.overlay_manager.add((Overlay)this.bog_overlay);
    }

    protected void shutDown() throws Exception {
        log.info("Stopping Temple Trek Bog Helper!");
        this.overlay_manager.remove((Overlay)this.bog_overlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("This ground seems quite firm.")) {
            this.bog_overlay.setTargetFirm();
        }
        if (event.getMessage().equals("The ground seems firm enough.")) {
            this.bog_overlay.setFirm();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            Player player = this.client.getLocalPlayer();
            WorldPoint world = player.getWorldLocation();
            LocalPoint local = player.getLocalLocation();
            int region_id = world.getRegionID();
            if (this.client.isInInstancedRegion()) {
                region_id = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID();
            }
            if (region_id != 8270) {
                this.bog_overlay.clearMarked();
            }
        }
    }

    @Provides
    TempleTrekkingBogHelperConfig provideConfig(ConfigManager configManager) {
        return (TempleTrekkingBogHelperConfig)configManager.getConfig(TempleTrekkingBogHelperConfig.class);
    }
}

