/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite;

import com.google.inject.Inject;
import com.sololegends.runelite.TempleTrekkingBogHelperConfig;
import com.sololegends.runelite.TempleTrekkingBogHelperPlugin;
import com.sololegends.runelite.data.TileMarked;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.Direction;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TempleTrekkingBogHelperOverlay
extends Overlay {
    private final Set<TileMarked> MARKED_TILES = new HashSet<TileMarked>();
    private final Client client;
    private final TempleTrekkingBogHelperConfig config;

    @Inject
    private TempleTrekkingBogHelperOverlay(Client client, TempleTrekkingBogHelperPlugin plugin, TempleTrekkingBogHelperConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.config = config;
    }

    public void setTargetFirm() {
        Player player = this.client.getLocalPlayer();
        LocalPoint local = player.getLocalLocation();
        Direction angle = this.getNearestDirection(player.getOrientation());
        int sx = local.getSceneX();
        int sy = local.getSceneY();
        if (angle.equals((Object)Direction.NORTH)) {
            ++sy;
        } else if (angle.equals((Object)Direction.SOUTH)) {
            --sy;
        } else if (angle.equals((Object)Direction.EAST)) {
            ++sx;
        } else if (angle.equals((Object)Direction.WEST)) {
            --sx;
        }
        this.MARKED_TILES.add(new TileMarked(sx, sy, this.client.getPlane()));
    }

    public void setFirm() {
        Player player = this.client.getLocalPlayer();
        LocalPoint local = player.getLocalLocation();
        int sx = local.getSceneX();
        int sy = local.getSceneY();
        this.MARKED_TILES.add(new TileMarked(sx, sy, this.client.getPlane()));
    }

    public void clearMarked() {
        this.MARKED_TILES.clear();
    }

    public void markBogTiles(Graphics2D graphics) {
        Player player = this.client.getLocalPlayer();
        WorldPoint world = player.getWorldLocation();
        LocalPoint local = player.getLocalLocation();
        int region_id = world.getRegionID();
        if (this.client.isInInstancedRegion()) {
            region_id = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID();
        }
        if (region_id != 8270) {
            return;
        }
        int z = this.client.getPlane();
        Tile[][][] tiles = this.client.getScene().getTiles();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                GroundObject tile_obj = tile.getGroundObject();
                if (tile_obj == null || tile_obj.getId() != 13838) continue;
                if (this.config.cheatMode()) {
                    OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)tile_obj, (String)"FIRM", (Color)Color.GREEN);
                    continue;
                }
                if (!this.MARKED_TILES.contains(new TileMarked(x, y, z))) continue;
                OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)tile_obj, (String)"FIRM", (Color)Color.GREEN);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        this.markBogTiles(graphics);
        return null;
    }

    public Direction getNearestDirection(int angle) {
        int round = angle >>> 9;
        int up = angle & 0x100;
        if (up != 0) {
            ++round;
        }
        switch (round & 3) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
        }
        throw new IllegalStateException();
    }
}

